/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.lang.ASTNode;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&)\u0011Y\u00012A\u0007\u00021\t\tB\u0001\u0002\u0001\t\u0006U\t\u0001dA\r\u0007\u0011\u000fiA!\u0003\u0002\n\u0003\u0011\u0016\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/checkers/SafeCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;"}, moduleName="kotlin-compiler")
public final class SafeCallChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ASTNode aSTNode = resolvedCall.getCall().getCallOperationNode();
        if (aSTNode == null) {
            return;
        }
        ASTNode operationNode = aSTNode;
        if (Intrinsics.areEqual(operationNode.getElementType(), KtTokens.SAFE_ACCESS) && Intrinsics.areEqual((Object)resolvedCall.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER)) {
            context.trace.report(Errors.UNEXPECTED_SAFE_CALL.on(operationNode.getPsi()));
        }
    }
}

