/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtBlockExpression
extends KtExpressionImpl
implements PsiModifiableCodeBlock,
KtStatementExpression {
    public KtBlockExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtBlockExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtBlockExpression", "accept"));
        }
        return visitor2.visitBlockExpression(this, data);
    }

    @ReadOnly
    @NotNull
    public List<KtExpression> getStatements() {
        List<KtExpression> list = Arrays.asList(this.findChildrenByClass(KtExpression.class));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtBlockExpression", "getStatements"));
        }
        return list;
    }

    @Nullable
    public TextRange getLastBracketRange() {
        PsiElement rBrace = this.getRBrace();
        return rBrace != null ? rBrace.getTextRange() : null;
    }

    @Nullable
    public PsiElement getRBrace() {
        return this.findChildByType(KtTokens.RBRACE);
    }

    @Nullable
    public PsiElement getLBrace() {
        return this.findChildByType(KtTokens.LBRACE);
    }
}

