/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.IntRange;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.AbiVersionUtil;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t%\u0015\t\u0001bB\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\r\u0001A-\u0011$\u0001M\u0001;\u0003-\u00115\u0004\u0003\u0002\u0013%A\u0011!D\u0004\n\u0005%\t\u0001DA\u0005\u0003\u0013\u0005A*\u0001g\u0001R\u0007\u0005A1!\n\u0005\t\n5\u0011A\u0012\u0001M\u00033\rAQ!D\u0001\u0019\u0005%\u0002Ba\u0011\u0005\t\u000359\u0011BA\u0005\u00021\tI!!C\u0001\u0019\u0006a\r\u0011k\u0001\u0003\u0006\u00015\u0011Aq\u0001\u0005\u0005"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "(Ljava/util/Map;)V", "getPackageFqName2Parts", "()Ljava/util/Map;", "findPackageParts", "packageFqName", "Companion"}, moduleName="kotlin-compiler")
public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @NotNull
    public static final ModuleMapping EMPTY;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts) {
        this.packageFqName2Parts = packageFqName2Parts;
    }

    static {
        Companion = org.jetbrains.kotlin.load.kotlin.ModuleMapping$Companion.INSTANCE;
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap());
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!B\u0001\u0005\u0005\u0015\t\u0001\"\u0003\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0013\u0002c\u0003\u000e\u0003a\u0011\u0011$\u0002\u0003\u0002\u0011\u0019i!\u0001$\u0001\u0019\u000e%ZAa\u0011\u0005\t\u00045\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u000bA1!k\u0006\u0005\u0007\"\u000b\u0001rA\u0007\u00021\u0011\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0003\t\u000b\u0001"}, strings={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "getEMPTY", "()Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "MAPPING_FILE_EXT", "", "getMAPPING_FILE_EXT", "()Ljava/lang/String;", "create", "proto", ""}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getMAPPING_FILE_EXT() {
            return MAPPING_FILE_EXT;
        }

        @NotNull
        public final ModuleMapping getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] proto) {
            JvmPackageTable.PackageTable parseFrom;
            List list;
            Iterable destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            if (proto == null) {
                return this.getEMPTY();
            }
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(proto));
            int size = inputStream.readInt();
            Iterable iterable = new IntRange(0, size - 1);
            BinaryVersion.Companion companion = BinaryVersion.Companion;
            void var6_6 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                int n = ((Number)item$iv$iv).intValue();
                list = destination$iv$iv;
                Integer n2 = inputStream.readInt();
                list.add(n2);
            }
            list = (List)destination$iv$iv;
            BinaryVersion version = companion.create(CollectionsKt.toIntArray(list));
            if (AbiVersionUtil.isAbiVersionCompatible(version) && (parseFrom = JvmPackageTable.PackageTable.parseFrom(inputStream)) != null) {
                void $receiver$iv2;
                HashMap<String, PackageParts> packageFqNameParts = MapsKt.hashMapOf(new Pair[0]);
                destination$iv$iv = parseFrom.getPackagePartsList();
                for (Object element$iv : $receiver$iv2) {
                    void $receiver$iv3;
                    JvmPackageTable.PackageParts it = (JvmPackageTable.PackageParts)element$iv;
                    String string = it.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull(string, "it.packageFqName");
                    PackageParts packageParts = new PackageParts(string);
                    packageFqNameParts.put(it.getPackageFqName(), packageParts);
                    Iterable $i$f$mapTo = it.getClassNameList();
                    for (Object element$iv2 : $receiver$iv3) {
                        String it2 = (String)element$iv2;
                        packageParts.getParts().add(it2);
                    }
                }
                return new ModuleMapping(packageFqNameParts, null);
            }
            return this.getEMPTY();
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ModuleMapping create$default(Companion companion, byte[] byArray, int n) {
            if ((n & 1) != 0) {
                byArray = null;
            }
            return companion.create(byArray);
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

