/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.extensions;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!\u0002\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq\"\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0005)\u0011\u0001b\u0001\u0005\u00171\u0001QC\u0001\u0003\u0001\u0011\u0003I\u0012\u0001G\u0001\"\u001c%\u0019\u00012A\u0007\u00021\tIa\u0001#\u0002\u000e\t%\u0011\u0011\"\u0001\u000f\u00011\r\t6!\u0001E\u0004K)Aa!\u0004\u0003\n\u0005%\tA\u0004\u0001M\u00073\rAq!D\u0001\u0019\u0010\u0015n\u0001\u0002C\u0007\u00021#I2\u0001C\u0004\u000e\u0003a=\u0011d\u0001\u0005\n\u001b\u0005a\u0002!U\u0002\u0002\u0011')s\u0001\u0003\u0006\u000e\u0003aE\u0011d\u0001\u0005\b\u001b\u0005Az!\u000b\u0006\u0005\u0003\"A)!\u0004\u0003\n\u0005%\tA\u0004\u0001\r\u0004#\u000e\tQ\u0001A\u0015\u000e\t\rC\u0001\u0002B\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u0019\nE\u001bA!\u0002\u0001\u000e\u0005\u0011)\u00012\u0002"}, strings={"Lorg/jetbrains/kotlin/extensions/ProjectExtensionDescriptor;", "T", "", "name", "", "extensionClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)V", "extensionPointName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstances", "", "project", "Lcom/intellij/openapi/project/Project;", "registerExtension", "", "extension", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "registerExtensionPoint"}, moduleName="kotlin-compiler")
public class ProjectExtensionDescriptor<T> {
    @NotNull
    private final ExtensionPointName<T> extensionPointName;
    private final Class<T> extensionClass;

    @NotNull
    public final ExtensionPointName<T> getExtensionPointName() {
        return this.extensionPointName;
    }

    public final void registerExtensionPoint(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        ExtensionsArea extensionsArea = Extensions.getArea(project);
        String string = this.extensionPointName.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        extensionsArea.registerExtensionPoint(string, this.extensionClass.getName(), ExtensionPoint.Kind.INTERFACE);
    }

    public final void registerExtension(@NotNull Project project, T extension) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Extensions.getArea(project).getExtensionPoint(this.extensionPointName).registerExtension(extension);
    }

    @NotNull
    public final Collection<T> getInstances(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        ExtensionsArea projectArea = Extensions.getArea(project);
        String string = this.extensionPointName.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (!projectArea.hasExtensionPoint(string)) {
            return CollectionsKt.listOf();
        }
        return ArraysKt.toList(projectArea.getExtensionPoint(this.extensionPointName).getExtensions());
    }

    public ProjectExtensionDescriptor(@NotNull String name, @NotNull Class<T> extensionClass) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(extensionClass, "extensionClass");
        this.extensionClass = extensionClass;
        ExtensionPointName extensionPointName = ExtensionPointName.create(name);
        if (extensionPointName == null) {
            Intrinsics.throwNpe();
        }
        this.extensionPointName = extensionPointName;
    }
}

