/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClientKt;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RmiFriendlyCompilationCancelledException;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\n\u0015\tAqA\u0003\u0002\u0011\u0005a\u0001!G\u0001\u0019\u0002\u0005^\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0003\u0005\u0003!\u0011Q\"\u0001M\u0003#\u000e\t\u0001bA\u0013\u0005\t-A\t\"D\u0001\u0019\u0013%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001C\u0004\u0011\u0011Is\u0002b\"\u001d\u0011\u0013i\u0011\u0001G\u0003\u001d\u0007\u0001\u001a\u0011kA\u0004\u0006\u00015\u0011A1\u0002\u0005\u0007#\t!i\u0001C\u0004*\u0015\u0011\u0019\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011k\u0001\u0003\u0006\u00015\u0011Aq\u0002\u0005\t"}, strings={"Lorg/jetbrains/kotlin/daemon/RemoteCompilationCanceledStatusClient;", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getFacade", "()Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "lastChecked", "", "getLastChecked", "()J", "setLastChecked", "(J)V", "getProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "checkCanceled", ""}, moduleName="kotlin-compiler")
public final class RemoteCompilationCanceledStatusClient
implements CompilationCanceledStatus {
    private volatile long lastChecked;
    @NotNull
    private final CompilerCallbackServicesFacade facade;
    @NotNull
    private final Profiler profiler;

    public final long getLastChecked() {
        return this.lastChecked;
    }

    public final void setLastChecked(long l) {
        this.lastChecked = l;
    }

    @Override
    public void checkCanceled() {
        long curNanos = System.nanoTime();
        if (curNanos - this.lastChecked > RemoteCompilationCanceledStatusClientKt.getCANCELED_STATUS_CHECK_THRESHOLD_NS()) {
            this.profiler.withMeasure(this, (Function0)new Function0<Unit>(this){
                final /* synthetic */ RemoteCompilationCanceledStatusClient this$0;

                public final void invoke() {
                    try {
                        this.this$0.getFacade().compilationCanceledStatus_checkCanceled();
                    }
                    catch (RmiFriendlyCompilationCancelledException e) {
                        throw (Throwable)new CompilationCanceledException();
                    }
                }
                {
                    this.this$0 = remoteCompilationCanceledStatusClient;
                    super(0);
                }
            });
            this.lastChecked = curNanos;
        }
    }

    @NotNull
    public final CompilerCallbackServicesFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final Profiler getProfiler() {
        return this.profiler;
    }

    public RemoteCompilationCanceledStatusClient(@NotNull CompilerCallbackServicesFacade facade, @NotNull Profiler profiler) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        Intrinsics.checkParameterIsNotNull(profiler, "profiler");
        this.facade = facade;
        this.profiler = profiler;
        this.lastChecked = System.nanoTime();
    }

    public /* synthetic */ RemoteCompilationCanceledStatusClient(CompilerCallbackServicesFacade compilerCallbackServicesFacade, Profiler profiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            profiler = new DummyProfiler();
        }
        this(compilerCallbackServicesFacade, profiler);
    }
}

