/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceTreeToPsiMap {
    private SourceTreeToPsiMap() {
    }

    @Nullable
    public static PsiElement treeElementToPsi(@Nullable ASTNode element) {
        return element == null ? null : element.getPsi();
    }

    @NotNull
    public static <T extends PsiElement> T treeToPsiNotNull(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/SourceTreeToPsiMap", "treeToPsiNotNull"));
        }
        PsiElement psi = element.getPsi();
        assert (psi != null) : element;
        PsiElement psiElement2 = psi;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/SourceTreeToPsiMap", "treeToPsiNotNull"));
        }
        return (T)psiElement2;
    }

    @Nullable
    public static ASTNode psiElementToTree(@Nullable PsiElement psiElement2) {
        return psiElement2 == null ? null : psiElement2.getNode();
    }

    @NotNull
    public static TreeElement psiToTreeNotNull(@NotNull PsiElement psiElement2) {
        if (psiElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/impl/source/SourceTreeToPsiMap", "psiToTreeNotNull"));
        }
        ASTNode node = psiElement2.getNode();
        assert (node instanceof TreeElement) : psiElement2 + ", " + node;
        TreeElement treeElement = (TreeElement)node;
        if (treeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/SourceTreeToPsiMap", "psiToTreeNotNull"));
        }
        return treeElement;
    }

    public static boolean hasTreeElement(@Nullable PsiElement psiElement2) {
        return psiElement2 instanceof TreeElement || psiElement2 instanceof ASTDelegatePsiElement || psiElement2 instanceof PsiFileImpl;
    }
}

