/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    public static final Key<FoldingBuilder> FOLDING_BUILDER = new Key("FOLDING_BUILDER");
    private final List<FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    @NotNull
    public List<FoldingBuilder> getAllBuilders() {
        List<FoldingBuilder> list = Collections.unmodifiableList(this.myBuilders);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CompositeFoldingBuilder", "getAllBuilders"));
        }
        return list;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }
}

