/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReferenceBase
implements PsiReference {
    private final XPathElement element;
    private final ASTNode nameNode;

    public ReferenceBase(XPathElement element, ASTNode nameNode) {
        this.element = element;
        this.nameNode = nameNode;
    }

    public XPathElement getElement() {
        return this.element;
    }

    public TextRange getRangeInElement() {
        int outer = this.element.getTextRange().getStartOffset();
        return TextRange.from((int)(this.nameNode.getTextRange().getStartOffset() - outer), (int)this.nameNode.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.nameNode.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/ReferenceBase", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("unsupported");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/psi/impl/ReferenceBase", "bindToElement"));
        }
        throw new IncorrectOperationException("unsupported");
    }

    public boolean isReferenceTo(PsiElement element) {
        return Comparing.equal((Object)this.resolve(), (Object)element);
    }

    @NotNull
    public abstract Object[] getVariants();

    public boolean isSoft() {
        return true;
    }

    public ASTNode getNameNode() {
        return this.nameNode;
    }
}

