/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.name;

import hidden.org.apache.jackrabbit.name.GenerationalCache;
import hidden.org.apache.jackrabbit.name.NameException;
import hidden.org.apache.jackrabbit.name.NameResolver;
import hidden.org.apache.jackrabbit.name.QName;
import javax.jcr.NamespaceException;

public class CachingNameResolver
implements NameResolver {
    private final NameResolver resolver;
    private final GenerationalCache cache;

    public CachingNameResolver(NameResolver resolver, GenerationalCache cache) {
        this.resolver = resolver;
        this.cache = cache;
    }

    public CachingNameResolver(NameResolver resolver) {
        this(resolver, new GenerationalCache());
    }

    public QName getQName(String name) throws NameException, NamespaceException {
        QName qname = (QName)this.cache.get(name);
        if (qname == null) {
            qname = this.resolver.getQName(name);
            this.cache.put(name, qname);
        }
        return qname;
    }

    public String getJCRName(QName qname) throws NamespaceException {
        String name = (String)this.cache.get(qname);
        if (name == null) {
            name = this.resolver.getJCRName(qname);
            this.cache.put(qname, name);
        }
        return name;
    }
}

