/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.TextCopyProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.Cell;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ListWithSelection;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComboBoxTableCellRenderer;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEntry;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseEditor
extends DialogWrapper
implements DataProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final MyTableModel myTableModel;
    @NotNull
    private final JBTable myCommitsTable;
    @NotNull
    private final CopyProvider myCopyProvider;

    protected GitRebaseEditor(@NotNull Project project, @NotNull VirtualFile gitRoot, @NotNull List<GitRebaseEntry> entries) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseEditor", "<init>"));
        }
        if (gitRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRoot", "git4idea/rebase/GitRebaseEditor", "<init>"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "git4idea/rebase/GitRebaseEditor", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.myRoot = gitRoot;
        this.setTitle(GitBundle.getString("rebase.editor.title"));
        this.setOKButtonText(GitBundle.getString("rebase.editor.button"));
        this.myTableModel = new MyTableModel(entries);
        this.myCommitsTable = new JBTable((TableModel)this.myTableModel);
        this.myCommitsTable.setSelectionMode(1);
        this.myCommitsTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        ComboBox editorComboBox = new ComboBox();
        for (GitRebaseEntry.Action option : GitRebaseEntry.Action.values()) {
            editorComboBox.addItem(option);
        }
        TableColumn actionColumn = this.myCommitsTable.getColumnModel().getColumn(0);
        actionColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)editorComboBox));
        actionColumn.setCellRenderer(ComboBoxTableCellRenderer.INSTANCE);
        this.myCommitsTable.setDefaultRenderer(String.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    this.append(value.toString());
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)GitRebaseEditor.this.myCommitsTable, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
                }
            }
        });
        this.myTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GitRebaseEditor.this.validateFields();
            }
        });
        this.installSpeedSearch();
        this.myCopyProvider = new MyCopyProvider();
        this.adjustColumnWidth(0);
        this.adjustColumnWidth(1);
        this.init();
    }

    private void installSpeedSearch() {
        new TableSpeedSearch((JTable)this.myCommitsTable, (PairFunction)new PairFunction<Object, Cell, String>(){

            @Nullable
            public String fun(Object o, Cell cell) {
                return cell.column == 0 ? null : String.valueOf(o);
            }
        });
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myCommitsTable;
    }

    private void adjustColumnWidth(int columnIndex) {
        int contentWidth = this.myCommitsTable.getExpandedColumnWidth(columnIndex) + 10;
        TableColumn column = this.myCommitsTable.getColumnModel().getColumn(columnIndex);
        column.setMaxWidth(contentWidth);
        column.setPreferredWidth(contentWidth);
    }

    private void validateFields() {
        GitRebaseEntry.Action action;
        int i;
        List entries = this.myTableModel.myEntries;
        if (entries.size() == 0) {
            this.setErrorText(GitBundle.getString("rebase.editor.invalid.entryset"));
            this.setOKActionEnabled(false);
            return;
        }
        for (i = 0; i < entries.size() && ((GitRebaseEntry)entries.get(i)).getAction() == GitRebaseEntry.Action.skip; ++i) {
        }
        if (i < entries.size() && ((action = ((GitRebaseEntry)entries.get(i)).getAction()) == GitRebaseEntry.Action.squash || action == GitRebaseEntry.Action.fixup)) {
            this.setErrorText(GitBundle.message("rebase.editor.invalid.squash", StringUtil.toLowerCase((String)action.name())));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    protected JComponent createCenterPanel() {
        return ToolbarDecorator.createDecorator((JTable)this.myCommitsTable).disableAddAction().disableRemoveAction().addExtraAction((AnActionButton)new MyDiffAction()).setMoveUpAction((AnActionButtonRunnable)new MoveUpDownActionListener(MoveDirection.UP)).setMoveDownAction((AnActionButtonRunnable)new MoveUpDownActionListener(MoveDirection.DOWN)).createPanel();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.RebaseCommits";
    }

    @NotNull
    public List<GitRebaseEntry> getEntries() {
        List list = this.myTableModel.myEntries;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEditor", "getEntries"));
        }
        return list;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyProvider;
        }
        return null;
    }

    private class MyCopyProvider
    extends TextCopyProvider {
        private MyCopyProvider() {
        }

        @Nullable
        public Collection<String> getTextLinesToCopy() {
            if (GitRebaseEditor.this.myCommitsTable.getSelectedRowCount() > 0) {
                ArrayList lines = ContainerUtil.newArrayList();
                for (int row : GitRebaseEditor.this.myCommitsTable.getSelectedRows()) {
                    lines.add(GitRebaseEditor.this.myTableModel.getStringToCopy(row));
                }
                return lines;
            }
            return null;
        }
    }

    private class MoveUpDownActionListener
    implements AnActionButtonRunnable {
        private final MoveDirection direction;

        public MoveUpDownActionListener(MoveDirection direction) {
            if (direction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "git4idea/rebase/GitRebaseEditor$MoveUpDownActionListener", "<init>"));
            }
            this.direction = direction;
        }

        public void run(AnActionButton button) {
            GitRebaseEditor.this.myTableModel.moveRows(GitRebaseEditor.this.myCommitsTable.getSelectedRows(), this.direction);
        }
    }

    private class MyDiffAction
    extends ToolbarDecorator.ElementActionButton
    implements DumbAware {
        MyDiffAction() {
            super("View", "View commit contents", AllIcons.Actions.Diff);
            this.registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)GitRebaseEditor.this.myCommitsTable);
        }

        public void actionPerformed(AnActionEvent e) {
            int row = GitRebaseEditor.this.myCommitsTable.getSelectedRow();
            assert (row >= 0 && row < GitRebaseEditor.this.myTableModel.getRowCount());
            GitRebaseEntry entry = (GitRebaseEntry)GitRebaseEditor.this.myTableModel.myEntries.get(row);
            GitUtil.showSubmittedFiles(GitRebaseEditor.this.myProject, entry.getCommit(), GitRebaseEditor.this.myRoot, false, false);
        }

        public boolean isEnabled() {
            return super.isEnabled() && GitRebaseEditor.this.myCommitsTable.getSelectedRowCount() == 1;
        }
    }

    private static enum MoveDirection {
        UP,
        DOWN;


        public int offset() {
            return this == UP ? -1 : 1;
        }

        public int[] preprocessRowIndexes(int[] selection) {
            int[] copy = (int[])selection.clone();
            Arrays.sort(copy);
            return this == UP ? copy : ArrayUtil.reverseArray((int[])copy);
        }
    }

    private static class ContiguousIntIntervalTracker {
        private Integer myMin = null;
        private Integer myMax = null;
        private static final int UNSET_VALUE = -1;

        private ContiguousIntIntervalTracker() {
        }

        public Integer getMin() {
            return this.myMin == null ? -1 : this.myMin;
        }

        public Integer getMax() {
            return this.myMax == null ? -1 : this.myMax;
        }

        public void track(int ... entries) {
            for (int entry : entries) {
                this.checkMax(entry);
                this.checkMin(entry);
            }
        }

        private void checkMax(int entry) {
            if (null == this.myMax || entry > this.myMax) {
                this.myMax = entry;
            }
        }

        private void checkMin(int entry) {
            if (null == this.myMin || entry < this.myMin) {
                this.myMin = entry;
            }
        }

        public boolean hasValues() {
            return null != this.myMin && null != this.myMax;
        }
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private static final int ACTION_COLUMN = 0;
        private static final int HASH_COLUMN = 1;
        private static final int SUBJECT_COLUMN = 2;
        @NotNull
        private final List<GitRebaseEntry> myEntries;
        private int[] myLastEditableSelectedRows;

        MyTableModel(List<GitRebaseEntry> entries) {
            if (entries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "git4idea/rebase/GitRebaseEditor$MyTableModel", "<init>"));
            }
            this.myLastEditableSelectedRows = new int[0];
            this.myEntries = entries;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? ListWithSelection.class : String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return GitBundle.getString("rebase.editor.action.column");
                }
                case 1: {
                    return GitBundle.getString("rebase.editor.commit.column");
                }
                case 2: {
                    return GitBundle.getString("rebase.editor.comment.column");
                }
            }
            throw new IllegalArgumentException("Unsupported column index: " + column);
        }

        @Override
        public int getRowCount() {
            return this.myEntries.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            GitRebaseEntry e = this.myEntries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return new ListWithSelection(Arrays.asList(GitRebaseEntry.Action.values()), (Object)e.getAction());
                }
                case 1: {
                    return e.getCommit();
                }
                case 2: {
                    return e.getSubject();
                }
            }
            throw new IllegalArgumentException("Unsupported column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0);
            if (ArrayUtil.indexOf((int[])this.myLastEditableSelectedRows, (int)rowIndex) > -1) {
                ContiguousIntIntervalTracker intervalBuilder = new ContiguousIntIntervalTracker();
                for (int lastEditableSelectedRow : this.myLastEditableSelectedRows) {
                    intervalBuilder.track(lastEditableSelectedRow);
                    this.setRowAction(aValue, lastEditableSelectedRow, columnIndex);
                }
                this.setSelection(intervalBuilder);
            } else {
                this.setRowAction(aValue, rowIndex, columnIndex);
            }
        }

        public void addRow() {
            throw new UnsupportedOperationException();
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            GitRebaseEntry movingElement = this.myEntries.remove(oldIndex);
            this.myEntries.add(newIndex, movingElement);
            this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        public void removeRow(int idx) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public String getStringToCopy(int row) {
            if (row < 0 || row >= this.myEntries.size()) {
                return null;
            }
            GitRebaseEntry e = this.myEntries.get(row);
            return e.getCommit() + " " + e.getSubject();
        }

        private void setSelection(@NotNull ContiguousIntIntervalTracker intervalBuilder) {
            if (intervalBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intervalBuilder", "git4idea/rebase/GitRebaseEditor$MyTableModel", "setSelection"));
            }
            GitRebaseEditor.this.myCommitsTable.getSelectionModel().setSelectionInterval(intervalBuilder.getMin(), intervalBuilder.getMax());
        }

        private void setRowAction(@NotNull Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aValue", "git4idea/rebase/GitRebaseEditor$MyTableModel", "setRowAction"));
            }
            GitRebaseEntry e = this.myEntries.get(rowIndex);
            e.setAction((GitRebaseEntry.Action)((Object)aValue));
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            this.myLastEditableSelectedRows = GitRebaseEditor.this.myCommitsTable.getSelectedRows();
            return columnIndex == 0;
        }

        public void moveRows(@NotNull int[] rows, @NotNull MoveDirection direction) {
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "git4idea/rebase/GitRebaseEditor$MyTableModel", "moveRows"));
            }
            if (direction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "git4idea/rebase/GitRebaseEditor$MyTableModel", "moveRows"));
            }
            GitRebaseEditor.this.myCommitsTable.removeEditor();
            ContiguousIntIntervalTracker selectionInterval = new ContiguousIntIntervalTracker();
            ContiguousIntIntervalTracker rowsUpdatedInterval = new ContiguousIntIntervalTracker();
            for (int row : direction.preprocessRowIndexes(rows)) {
                int targetIndex = row + direction.offset();
                this.assertIndexInRange(row, targetIndex);
                Collections.swap(this.myEntries, row, targetIndex);
                rowsUpdatedInterval.track(targetIndex, row);
                selectionInterval.track(targetIndex);
            }
            if (selectionInterval.hasValues()) {
                this.setSelection(selectionInterval);
                this.fireTableRowsUpdated(rowsUpdatedInterval.getMin(), rowsUpdatedInterval.getMax());
            }
        }

        private void assertIndexInRange(int ... rowIndexes) {
            for (int rowIndex : rowIndexes) {
                assert (rowIndex >= 0);
                assert (rowIndex < this.myEntries.size());
            }
        }
    }
}

