/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern.compiler;

import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

class InstrumentationItem
implements FileProcessingCompiler.ProcessingItem {
    private final VirtualFile myClassFile;
    private final boolean myJDK6;

    public InstrumentationItem(@NotNull VirtualFile classFile, boolean jdk6) {
        if (classFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFile", "org/intellij/plugins/intelliLang/pattern/compiler/InstrumentationItem", "<init>"));
        }
        this.myJDK6 = jdk6;
        this.myClassFile = classFile;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myClassFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/pattern/compiler/InstrumentationItem", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getClassFile() {
        VirtualFile virtualFile = this.myClassFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/pattern/compiler/InstrumentationItem", "getClassFile"));
        }
        return virtualFile;
    }

    public ValidityState getValidityState() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstrumentationItem item = (InstrumentationItem)o;
        return this.myClassFile.equals(item.myClassFile);
    }

    public int hashCode() {
        return this.myClassFile.hashCode();
    }

    public String toString() {
        return "Item: " + this.myClassFile.getPresentableUrl();
    }

    public boolean isJDK6() {
        return this.myJDK6;
    }
}

