/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.Condition;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilder;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.JarBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.service.JpsServiceManager;

public class ArtifactInstructionsBuilderImpl
implements ArtifactInstructionsBuilder {
    private final Map<String, JarInfo> myJarByPath;
    private final List<ArtifactRootDescriptor> myDescriptors;
    private final ModuleExcludeIndex myRootsIndex;
    private final Iterable<ArtifactRootCopyingHandlerProvider> myCopyingHandlerProviders;
    private int myRootIndex;
    private final IgnoredFileIndex myIgnoredFileIndex;
    private ArtifactBuildTarget myBuildTarget;
    private final JpsModel myModel;
    private final BuildDataPaths myBuildDataPaths;

    public ArtifactInstructionsBuilderImpl(@NotNull ModuleExcludeIndex rootsIndex, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull ArtifactBuildTarget target, @NotNull JpsModel model, @NotNull BuildDataPaths dataPaths) {
        if (rootsIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsIndex", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "<init>"));
        }
        if (ignoredFileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredFileIndex", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "<init>"));
        }
        if (dataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPaths", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "<init>"));
        }
        this.myRootsIndex = rootsIndex;
        this.myIgnoredFileIndex = ignoredFileIndex;
        this.myBuildTarget = target;
        this.myModel = model;
        this.myBuildDataPaths = dataPaths;
        this.myJarByPath = new HashMap<String, JarInfo>();
        this.myDescriptors = new ArrayList<ArtifactRootDescriptor>();
        this.myCopyingHandlerProviders = JpsServiceManager.getInstance().getExtensions(ArtifactRootCopyingHandlerProvider.class);
    }

    public IgnoredFileIndex getIgnoredFileIndex() {
        return this.myIgnoredFileIndex;
    }

    public boolean addDestination(@NotNull ArtifactRootDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "addDestination"));
        }
        this.myDescriptors.add(descriptor);
        return true;
    }

    public ModuleExcludeIndex getRootsIndex() {
        return this.myRootsIndex;
    }

    public boolean registerJarFile(@NotNull JarInfo jarInfo, @NotNull String outputPath) {
        if (jarInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarInfo", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "registerJarFile"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "registerJarFile"));
        }
        if (this.myJarByPath.containsKey(outputPath)) {
            return false;
        }
        this.myJarByPath.put(outputPath, jarInfo);
        return true;
    }

    @Override
    @NotNull
    public List<ArtifactRootDescriptor> getDescriptors() {
        List<ArtifactRootDescriptor> list = this.myDescriptors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "getDescriptors"));
        }
        return list;
    }

    public FileBasedArtifactRootDescriptor createFileBasedRoot(@NotNull File file, @NotNull SourceFileFilter filter, @NotNull DestinationInfo destinationInfo, FileCopyingHandler handler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createFileBasedRoot"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createFileBasedRoot"));
        }
        if (destinationInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationInfo", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createFileBasedRoot"));
        }
        return new FileBasedArtifactRootDescriptor(file, filter, this.myRootIndex++, this.myBuildTarget, destinationInfo, handler);
    }

    @Override
    @NotNull
    public FileCopyingHandler createCopyingHandler(@NotNull File file, @NotNull JpsPackagingElement contextElement) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createCopyingHandler"));
        }
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createCopyingHandler"));
        }
        for (ArtifactRootCopyingHandlerProvider provider : this.myCopyingHandlerProviders) {
            FileCopyingHandler handler = provider.createCustomHandler(this.myBuildTarget.getArtifact(), file, contextElement, this.myModel, this.myBuildDataPaths);
            if (handler == null) continue;
            FileCopyingHandler fileCopyingHandler = handler;
            if (fileCopyingHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createCopyingHandler"));
            }
            return fileCopyingHandler;
        }
        FileCopyingHandler fileCopyingHandler = FileCopyingHandler.DEFAULT;
        if (fileCopyingHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createCopyingHandler"));
        }
        return fileCopyingHandler;
    }

    public JarBasedArtifactRootDescriptor createJarBasedRoot(@NotNull File jarFile, @NotNull String pathInJar, @NotNull SourceFileFilter filter, @NotNull DestinationInfo destinationInfo, @NotNull Condition<String> pathInJarFilter) {
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createJarBasedRoot"));
        }
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createJarBasedRoot"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createJarBasedRoot"));
        }
        if (destinationInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationInfo", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createJarBasedRoot"));
        }
        if (pathInJarFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJarFilter", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl", "createJarBasedRoot"));
        }
        return new JarBasedArtifactRootDescriptor(jarFile, pathInJar, filter, this.myRootIndex++, this.myBuildTarget, destinationInfo, pathInJarFilter);
    }
}

