/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.highlighting.AbstractManifestQuickFix;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;
import org.jetbrains.lang.manifest.psi.Section;

public class MissingFinalNewlineInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String text;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection", "checkFile"));
        }
        if (file2 instanceof ManifestFile && (text = file2.getText()) != null && text.length() > 0 && !StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
            List<Section> sections = ((ManifestFile)file2).getSections();
            assert (sections.size() > 0) : text;
            Section section = sections.get(sections.size() - 1);
            ProblemDescriptor descriptor = manager.createProblemDescriptor(section.getLastChild(), ManifestBundle.message("inspection.newline.message", new Object[0]), (LocalQuickFix)new AddNewlineQuickFix(section), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    private static class AddNewlineQuickFix
    extends AbstractManifestQuickFix {
        private AddNewlineQuickFix(Section section) {
            super(section);
        }

        @NotNull
        public String getText() {
            String string = ManifestBundle.message("inspection.newline.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "invoke"));
            }
            PsiElement lastChild = startElement.getLastChild();
            if (lastChild instanceof Header) {
                lastChild.getNode().addLeaf((IElementType)ManifestTokenType.NEWLINE, (CharSequence)"\n", null);
            }
        }
    }
}

