/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header.impl;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public class ClassReferenceParser
extends StandardHeaderParser {
    public static final String MAIN_CLASS = "Main-Class";
    public static final String PREMAIN_CLASS = "Premain-Class";
    public static final String AGENT_CLASS = "Agent-Class";
    public static final HeaderParser INSTANCE = new ClassReferenceParser();

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        if (headerValuePart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValuePart", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "getReferences"));
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)headerValuePart);
        JavaClassReferenceProvider provider = module != null ? new JavaClassReferenceProvider(){

            @Override
            public GlobalSearchScope getScope(Project project) {
                return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            }
        } : new JavaClassReferenceProvider();
        PsiReference[] psiReferenceArray = provider.getReferencesByElement(headerValuePart);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "annotate"));
        }
        HeaderValue value = header.getHeaderValue();
        if (!(value instanceof HeaderValuePart)) {
            return false;
        }
        HeaderValuePart valuePart = (HeaderValuePart)value;
        String className = valuePart.getUnwrappedText();
        if (StringUtil.isEmptyOrSpaces((String)className)) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message("header.reference.invalid", new Object[0]));
            return true;
        }
        Project project = header.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)header);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(false) : ProjectScope.getAllScope((Project)project);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
        if (aClass == null) {
            String message = JavaErrorMessages.message("error.cannot.resolve.class", className);
            Annotation anno = holder.createErrorAnnotation(valuePart.getHighlightingRange(), message);
            anno.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            return true;
        }
        return this.checkClass(valuePart, aClass, holder);
    }

    protected boolean checkClass(@NotNull HeaderValuePart valuePart, @NotNull PsiClass aClass, @NotNull AnnotationHolder holder) {
        if (valuePart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePart", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "checkClass"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "checkClass"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "checkClass"));
        }
        String header = ((Header)valuePart.getParent()).getName();
        if (header.equals(MAIN_CLASS) && !PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message("header.main.class.invalid", new Object[0]));
            return true;
        }
        if (header.equals(PREMAIN_CLASS) && !ClassReferenceParser.hasInstrumenterMethod(aClass, "premain")) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message("header.pre-main.class.invalid", new Object[0]));
            return true;
        }
        if (header.equals(AGENT_CLASS) && !ClassReferenceParser.hasInstrumenterMethod(aClass, "agentmain")) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message("header.agent.class.invalid", new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean hasInstrumenterMethod(PsiClass aClass, String methodName) {
        for (PsiMethod method : aClass.findMethodsByName(methodName, false)) {
            if (!PsiType.VOID.equals((Object)method.getReturnType()) || !method.hasModifierProperty("public") || !method.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }
}

