/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.frame.ExecutionStackImpl;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"\u0001\u0003\f\u0019\u0001I\u0012\u0001'\u0001\"4%9\u0001\"A\u0007\u0006\u0013\r!\t!C\u0001\u0019\u0005a\r\u0011b\u0001E\u0003\u001b\u0005A2!\u0003\u0003\t\b5\u0011A\u0012\u0001\r\u0005\u0013\u0015!\u0011\u0001#\u0003\u000e\u00051\u0005\u0001$B)\u0004\u0003!-QE\u0003\u0005\b\u001b\u0011I!!C\u0001\u0019\u0011a=\u0011d\u0001E\t\u001b\u0005A\u0002\"j\u000b\u0005\u0003!9QRC\u0005\u0007\u0013\u0015\u0001\u0012\"\u0006\u0002\r\u0002aA\u0001\u0004\u0003M\b#\u000e\tA1C\r\u0004\u0011)i\u0011\u0001'\u0006\u001a\u0007!EQ\"\u0001\r\tK\rA1\"D\u0001\u0019\u0018%:A!\u0011\u0005\t\r5\t\u0001TB)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/frame/SuspendContextImpl;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/debugger/CallFrame;", "debugProcess", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;)V", "executionStack", "Lorg/jetbrains/debugger/frame/ExecutionStackImpl;", "evaluateExpression", "Lorg/jetbrains/concurrency/Promise;", "", "expression", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getActiveExecutionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;"}, moduleName="script-debugger-ui")
public class SuspendContextImpl
extends XSuspendContext {
    private final ExecutionStackImpl executionStack;

    @NotNull
    public final XExecutionStack getActiveExecutionStack() {
        return this.executionStack;
    }

    @NotNull
    public final Promise<String> evaluateExpression(@NotNull String expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        CallFrameView callFrameView = this.executionStack.getTopFrame();
        if (callFrameView == null) {
            return PromiseKt.rejectedPromise("Top frame is null");
        }
        CallFrameView frame = callFrameView;
        Promise<String> promise2 = this.evaluateExpression(frame.getCallFrame().getEvaluateContext(), expression);
        Intrinsics.checkExpressionValueIsNotNull(promise2, (String)"evaluateExpression(frame\u2026luateContext, expression)");
        return promise2;
    }

    private final Promise<String> evaluateExpression(EvaluateContext evaluateContext2, String expression) {
        return EvaluateContext.DefaultImpls.evaluate$default(evaluateContext2, expression, null, false, 6).thenAsync((AsyncFunction)evaluateExpression.1.INSTANCE);
    }

    public SuspendContextImpl(@NotNull SuspendContext<? extends CallFrame> suspendContext, @NotNull DebuggerViewSupport debugProcess, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo) {
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        this.executionStack = new ExecutionStackImpl(suspendContext, debugProcess, topFrameScript, topFrameSourceInfo);
    }

    public /* synthetic */ SuspendContextImpl(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo);
    }
}

