/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.Responses;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rA!\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\u0011\u0005\u0017!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005Ab!G\u0002\t\u000e5\t\u0001dA\r\u0004\u0011\u001di\u0011\u0001G\u0002\u001a\u0007!=Q\"\u0001\r\u0003"}, strings={"Lorg/jetbrains/builtInWebServer/DefaultWebServerPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "()V", "process", "", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectName", "decodedRawPath", "isCustomHost"}, moduleName="built-in-server")
public final class DefaultWebServerPathHandler
extends WebServerPathHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(@NotNull String path, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @NotNull String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        void pathInfo;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)decodedRawPath, (String)"decodedRawPath");
        Channel channel = context.channel();
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = (PathInfo)pathToFileManager.getPathToInfoCache().getIfPresent((Object)path);
        if ((PathInfo)pathInfo.element == null || !((PathInfo)pathInfo.element).isValid()) {
            pathInfo.element = pathToFileManager.doFindByRelativePath$built_in_server(path);
            if ((PathInfo)pathInfo.element == null) {
                if (StringsKt.isEmpty((CharSequence)path)) {
                    Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, "Index file doesn't exist.", (HttpRequest)request);
                    return true;
                }
                return false;
            }
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)((PathInfo)pathInfo.element));
        }
        boolean indexUsed = false;
        if (((PathInfo)pathInfo.element).isDirectory()) {
            if (!FileUtilKt.endsWithSlash(decodedRawPath)) {
                HttpRequest httpRequest = (HttpRequest)request;
                Channel channel2 = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
                WebServerPathHandlerKt.redirectToDirectory(httpRequest, channel2, isCustomHost ? path : projectName + "/" + path);
                return true;
            }
            VirtualFile indexVirtualFile = null;
            File indexFile = null;
            if (((PathInfo)pathInfo.element).getFile() == null) {
                File file2 = ((PathInfo)pathInfo.element).getIoFile();
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                indexFile = BuiltInWebServerKt.findIndexFile(file2);
            } else {
                VirtualFile virtualFile = ((PathInfo)pathInfo.element).getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                indexVirtualFile = BuiltInWebServerKt.findIndexFile(virtualFile);
            }
            if (indexFile == null && indexVirtualFile == null) {
                Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, "Index file doesn't exist.", (HttpRequest)request);
                return true;
            }
            indexUsed = true;
            pathInfo.element = new PathInfo(indexFile, indexVirtualFile, ((PathInfo)pathInfo.element).getRoot(), ((PathInfo)pathInfo.element).getModuleName(), ((PathInfo)pathInfo.element).isLibrary());
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)((PathInfo)pathInfo.element));
        }
        if (!indexUsed && !FileUtilKt.endsWithName(path, ((PathInfo)pathInfo.element).getName())) {
            if (FileUtilKt.endsWithSlash(decodedRawPath)) {
                indexUsed = true;
            } else {
                String parentPath = FileUtilKt.getParentPath(((PathInfo)pathInfo.element).getPath());
                if (parentPath != null) {
                    String string = PathUtilRt.getFileName((String)parentPath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getFileName(parentPath)");
                    if (FileUtilKt.endsWithName(path, string)) {
                        HttpRequest httpRequest = (HttpRequest)request;
                        Channel channel3 = channel;
                        Intrinsics.checkExpressionValueIsNotNull((Object)channel3, (String)"channel");
                        WebServerPathHandlerKt.redirectToDirectory(httpRequest, channel3, isCustomHost ? path : projectName + "/" + path);
                        return true;
                    }
                }
            }
        }
        String canonicalPath = indexUsed ? path + "/" + ((PathInfo)pathInfo.element).getName() : path;
        WebServerFileHandler[] webServerFileHandlerArray = (WebServerFileHandler[])WebServerFileHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (int i = 0; i < webServerFileHandlerArray.length; ++i) {
            WebServerFileHandler fileHandler = webServerFileHandlerArray[i];
            Logger logger = BuiltInWebServerKt.getLOG();
            try {
                PathInfo pathInfo2 = (PathInfo)pathInfo.element;
                Intrinsics.checkExpressionValueIsNotNull((Object)pathInfo2, (String)"pathInfo");
                CharSequence charSequence = canonicalPath;
                Channel channel4 = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)channel4, (String)"channel");
                if (!fileHandler.process(pathInfo2, charSequence, project, request, channel4, isCustomHost ? (String)null : projectName)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                continue;
            }
            catch (Throwable e$iv) {
                void $receiver$iv;
                $receiver$iv.error(e$iv);
            }
        }
        return false;
    }
}

