/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncAnnotation;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RncFoldingBuilder
implements FoldingBuilder {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder", "buildFoldRegions"));
        }
        ArrayList<FoldingDescriptor> regions = new ArrayList<FoldingDescriptor>();
        RncFoldingBuilder.process(node, document, regions);
        FoldingDescriptor[] foldingDescriptorArray = regions.size() > 0 ? regions.toArray(new FoldingDescriptor[regions.size()]) : FoldingDescriptor.EMPTY;
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder", "getPlaceholderText"));
        }
        IElementType type = node.getElementType();
        if (type == RncTokenTypes.LBRACE) {
            return "{ ... }";
        }
        if (RncFoldingBuilder.isCommentLike(type)) {
            return "# ...";
        }
        if (RncFoldingBuilder.isAnnotation(type)) {
            RncName element = ((RncAnnotation)node.getPsi()).getNameElement();
            if (element != null) {
                ASTNode n = element.getNode();
                assert (n != null);
                return EscapeUtil.unescapeText(n) + " [ ... ]";
            }
            return "[ ... ]";
        }
        return "...";
    }

    private static boolean isAnnotation(IElementType type) {
        return RncElementTypes.ANNOTATION == type || RncElementTypes.ANNOTATION_ELEMENT == type || RncElementTypes.FORWARD_ANNOTATION == type;
    }

    private static boolean isCommentLike(IElementType type) {
        return RncTokenTypes.COMMENTS.contains(type) || RncTokenTypes.DOC_TOKENS.contains(type);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder", "isCollapsedByDefault"));
        }
        return RncFoldingBuilder.isCommentLike(node.getElementType()) && CodeFoldingSettings.getInstance().COLLAPSE_DOC_COMMENTS;
    }

    private static void process(@Nullable ASTNode node, Document document, ArrayList<FoldingDescriptor> regions) {
        if (node == null) {
            return;
        }
        ASTNode[] braces = node.getChildren(RncTokenTypes.BRACES);
        if (braces.length == 2) {
            ASTNode lbrace = braces[0];
            ASTNode rbrace = braces[1];
            if (RncFoldingBuilder.shouldFold(lbrace, rbrace, document)) {
                TextRange range = new TextRange(lbrace.getStartOffset(), rbrace.getTextRange().getEndOffset());
                regions.add(new FoldingDescriptor(lbrace, range));
            }
        } else if (RncFoldingBuilder.isAnnotation(node.getElementType()) && RncFoldingBuilder.isOnDifferentLine(node.getFirstChildNode(), node.getLastChildNode(), document)) {
            regions.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        node = node.getFirstChildNode();
        while (node != null) {
            node = RncFoldingBuilder.checkNodeAndSiblings(node, RncTokenTypes.DOC_TOKENS, regions, document);
            node = RncFoldingBuilder.checkNodeAndSiblings(node, RncTokenTypes.COMMENTS, regions, document);
            RncFoldingBuilder.process(node, document, regions);
            if (node == null) continue;
            node = node.getTreeNext();
        }
    }

    @Nullable
    private static ASTNode checkNodeAndSiblings(@Nullable ASTNode node, TokenSet tokens, ArrayList<FoldingDescriptor> regions, Document document) {
        if (node != null && tokens.contains(node.getElementType())) {
            ASTNode start;
            ASTNode end = start = node;
            if ((node = node.getTreeNext()) != null) {
                do {
                    end = node;
                } while ((node = node.getTreeNext()) != null && tokens.contains(node.getElementType()));
            }
            if (end != start) {
                while (end.getPsi() instanceof PsiWhiteSpace) {
                    end = end.getTreePrev();
                }
                if (RncFoldingBuilder.isOnDifferentLine(start, end, document)) {
                    regions.add(new FoldingDescriptor(start, new TextRange(start.getStartOffset(), end.getTextRange().getEndOffset())));
                }
            }
        }
        return node;
    }

    private static boolean shouldFold(ASTNode first, ASTNode second, Document document) {
        if (first.getElementType() != RncTokenTypes.LBRACE) {
            return false;
        }
        if (second.getElementType() != RncTokenTypes.RBRACE) {
            return false;
        }
        return RncFoldingBuilder.isOnDifferentLine(first, second, document);
    }

    private static boolean isOnDifferentLine(ASTNode first, ASTNode second, Document document) {
        return document.getLineNumber(first.getStartOffset()) != document.getLineNumber(second.getStartOffset());
    }
}

