/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.integer.ConvertIntegerToDecimalPredicate;
import com.siyeh.ipp.integer.ConvertNumberIntentionBase;
import org.jetbrains.annotations.NotNull;

public class ConvertIntegerToDecimalIntention
extends ConvertNumberIntentionBase {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToDecimalPredicate convertIntegerToDecimalPredicate = new ConvertIntegerToDecimalPredicate();
        if (convertIntegerToDecimalPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/integer/ConvertIntegerToDecimalIntention", "getElementPredicate"));
        }
        return convertIntegerToDecimalPredicate;
    }

    @Override
    protected String convertValue(Number value, PsiType type, boolean negated) {
        if (PsiType.INT.equals((Object)type)) {
            int intValue = negated ? -value.intValue() : value.intValue();
            return Integer.toString(intValue);
        }
        if (PsiType.LONG.equals((Object)type)) {
            long longValue = negated ? -value.longValue() : value.longValue();
            return Long.toString(longValue) + "L";
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            float floatValue = negated ? -value.floatValue() : value.floatValue();
            return Float.toString(floatValue) + 'f';
        }
        if (PsiType.DOUBLE.equals((Object)type)) {
            double doubleValue = negated ? -value.doubleValue() : value.doubleValue();
            return Double.toString(doubleValue);
        }
        return null;
    }
}

