/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ipp.base.PsiElementPredicate;

class ExpressionPredicate
implements PsiElementPredicate {
    ExpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)parent;
        PsiExpression[] operands = expression.getOperands();
        if (operands.length < 2) {
            return false;
        }
        PsiExpression prevOperand = null;
        for (PsiExpression operand : operands) {
            PsiJavaToken token = expression.getTokenBeforeOperand(operand);
            if (element == token) {
                if (prevOperand != null && !operand.getText().equals(prevOperand.getText())) break;
                return false;
            }
            prevOperand = operand;
        }
        return !ComparisonUtils.isComparison((PsiExpression)expression);
    }
}

