/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.Nullable;

class ConstantSubexpressionPredicate
implements PsiElementPredicate {
    ConstantSubexpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiJavaToken token;
        if (element instanceof PsiJavaToken) {
            token = (PsiJavaToken)element;
        } else {
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiJavaToken) {
                token = (PsiJavaToken)prevSibling;
            } else {
                return false;
            }
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        PsiType type = polyadicExpression.getType();
        if (type == null || type.equalsToText("java.lang.String")) {
            return false;
        }
        PsiPolyadicExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(polyadicExpression, token);
        if (subexpression == null) {
            return false;
        }
        if (!ConstantSubexpressionPredicate.isPartOfLargerExpression(polyadicExpression)) {
            return false;
        }
        if (!PsiUtil.isConstantExpression((PsiExpression)subexpression)) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression((PsiExpression)subexpression);
        return value != null;
    }

    @Nullable
    static PsiPolyadicExpression getSubexpression(PsiPolyadicExpression expression, PsiJavaToken token) {
        PsiExpression[] operands = expression.getOperands();
        if (operands.length == 2) {
            return expression;
        }
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            PsiJavaToken currentToken = expression.getTokenBeforeOperand(operand);
            if (currentToken != token) continue;
            String binaryExpressionText = operands[i - 1].getText() + ' ' + token.getText() + ' ' + operand.getText();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
            return (PsiPolyadicExpression)factory.createExpressionFromText(binaryExpressionText, (PsiElement)expression);
        }
        return null;
    }

    private static boolean isPartOfLargerExpression(PsiPolyadicExpression expression) {
        if (expression.getOperands().length > 2) {
            return true;
        }
        PsiElement containingElement = expression.getParent();
        if (containingElement instanceof PsiExpression) {
            PsiExpression containingExpression = (PsiExpression)containingElement;
            return PsiUtil.isConstantExpression((PsiExpression)containingExpression);
        }
        return false;
    }
}

