/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertMessageNotStringInspection
extends BaseInspection {
    public boolean onlyWarnOnBoolean = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assert.message.not.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/AssertMessageNotStringInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("assert.message.of.type.boolean.problem.descriptor", type.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/AssertMessageNotStringInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assert.message.not.string.only.warn.boolean.option", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnBoolean");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertMessageNotStringVisitor();
    }

    private class AssertMessageNotStringVisitor
    extends BaseInspectionVisitor {
        private AssertMessageNotStringVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            super.visitAssertStatement(statement);
            PsiExpression assertDescription = statement.getAssertDescription();
            if (assertDescription == null) {
                return;
            }
            PsiType type = assertDescription.getType();
            if (AssertMessageNotStringInspection.this.onlyWarnOnBoolean) {
                if (PsiType.BOOLEAN.equals((Object)type)) {
                    this.registerError((PsiElement)assertDescription, type);
                    return;
                }
                PsiClassType javaLangBoolean = PsiType.BOOLEAN.getBoxedType((PsiElement)statement);
                if (javaLangBoolean != null && javaLangBoolean.equals((Object)type)) {
                    this.registerError((PsiElement)assertDescription, type);
                }
            } else if (type != null && !type.equalsToText("java.lang.String")) {
                this.registerError((PsiElement)assertDescription, type);
            }
        }
    }
}

