/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.encapsulation.ReturnOfCollectionFieldInspectionBase;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnOfCollectionFieldInspection
extends ReturnOfCollectionFieldInspectionBase {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[1];
        String text = referenceExpression.getText();
        if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Map")) {
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.SortedMap")) {
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSortedMap(" + text + ')', "java.util.SortedMap");
            }
            return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableMap(" + text + ')', "java.util.Map");
        }
        if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Collection")) {
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Set")) {
                if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.SortedSet")) {
                    return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSortedSet(" + text + ')', "java.util.SortedSet");
                }
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSet(" + text + ')', "java.util.Set");
            }
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.List")) {
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableList(" + text + ')', "java.util.List");
            }
            return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableCollection(" + text + ')', "java.util.Collection");
        }
        return null;
    }

    private static class ReturnOfCollectionFieldFix
    extends InspectionGadgetsFix {
        private final String myReplacementText;
        private final String myQualifiedClassName;

        ReturnOfCollectionFieldFix(@NonNls String replacementText, String qualifiedClassName) {
            this.myReplacementText = replacementText;
            this.myQualifiedClassName = qualifiedClassName;
        }

        @NotNull
        public String getFamilyName() {
            if ("Make return collection 'unmodifiable'" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/ReturnOfCollectionFieldInspection$ReturnOfCollectionFieldFix", "getFamilyName"));
            }
            return "Make return collection 'unmodifiable'";
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("return.of.collection.field.quickfix", this.myReplacementText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/ReturnOfCollectionFieldInspection$ReturnOfCollectionFieldFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            this.fixContainingMethodReturnType(referenceExpression);
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)referenceExpression, this.myReplacementText);
        }

        private void fixContainingMethodReturnType(PsiReferenceExpression referenceExpression) {
            String typeText;
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (method == null) {
                return;
            }
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null) {
                return;
            }
            PsiType type = returnTypeElement.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)this.myQualifiedClassName)) {
                return;
            }
            if (!(type instanceof PsiClassType)) {
                return;
            }
            Project project = referenceExpression.getProject();
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null || this.myQualifiedClassName.equals(aClass.getQualifiedName())) {
                return;
            }
            PsiType[] parameters = classType.getParameters();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (parameters.length > 0) {
                StringBuilder builder = new StringBuilder(this.myQualifiedClassName);
                builder.append('<');
                boolean comma = false;
                for (PsiType parameter : parameters) {
                    if (comma) {
                        builder.append(',');
                    } else {
                        comma = true;
                    }
                    builder.append(parameter.getCanonicalText());
                }
                builder.append('>');
                typeText = builder.toString();
            } else {
                typeText = this.myQualifiedClassName;
            }
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(typeText, (PsiElement)referenceExpression);
            PsiElement replacement = returnTypeElement.replace((PsiElement)newTypeElement);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            javaCodeStyleManager.shortenClassReferences(replacement);
            HighlightUtils.highlightElement(replacement);
        }
    }
}

