/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class BreakStatementWithLabelInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("break.statement.with.label.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/BreakStatementWithLabelInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("break.statement.with.label.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/BreakStatementWithLabelInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BreakStatementWithLabelVisitor();
    }

    private static class BreakStatementWithLabelVisitor
    extends BaseInspectionVisitor {
        private BreakStatementWithLabelVisitor() {
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/BreakStatementWithLabelInspection$BreakStatementWithLabelVisitor", "visitBreakStatement"));
            }
            super.visitBreakStatement(statement);
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            String labelText = labelIdentifier.getText();
            if (labelText == null) {
                return;
            }
            if (labelText.length() == 0) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

