/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColorPickerListenerFactory;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserColorLookup
extends LookupElementDecorator<LookupElement> {
    private static final String COLOR_STRING = XmlBundle.message((String)"choose.color.in.color.lookup", (Object[])new Object[0]);
    private static final Function<Color, String> COLOR_TO_STRING_CONVERTER = new Function<Color, String>(){

        public String fun(Color color) {
            return '#' + ColorUtil.toHex((Color)color);
        }
    };

    public UserColorLookup() {
        this(COLOR_TO_STRING_CONVERTER);
    }

    public UserColorLookup(Function<Color, String> colorToStringConverter) {
        this(colorToStringConverter, 2);
    }

    public UserColorLookup(final Function<Color, String> colorToStringConverter, int priority) {
        super(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)COLOR_STRING).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                UserColorLookup.handleUserSelection(context, (Function<Color, String>)colorToStringConverter);
            }
        }), (double)priority));
    }

    private static void handleUserSelection(InsertionContext context, @NotNull Function<Color, String> colorToStringConverter) {
        if (colorToStringConverter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorToStringConverter", "com/intellij/xml/util/UserColorLookup", "handleUserSelection"));
        }
        Color myColorAtCaret = null;
        Editor selectedTextEditor = context.getEditor();
        PsiElement element = context.getFile().findElementAt(selectedTextEditor.getCaretModel().getOffset());
        if (element instanceof XmlToken) {
            myColorAtCaret = UserColorLookup.getColorFromElement(element);
        }
        context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
        List<ColorPickerListener> listeners = ColorPickerListenerFactory.createListenersFor(element);
        Color color = ColorChooser.chooseColor((Component)WindowManager.getInstance().suggestParentWindow(context.getProject()), (String)XmlBundle.message((String)"choose.color.dialog.title", (Object[])new Object[0]), (Color)myColorAtCaret, (boolean)true, listeners, (boolean)true);
        if (color != null) {
            String colorString = (String)colorToStringConverter.fun((Object)color);
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)colorString);
            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
        }
    }

    @Nullable
    public static Color getColorFromElement(PsiElement element) {
        if (!(element instanceof XmlToken)) {
            return null;
        }
        return ColorMap.getColor(element.getText());
    }
}

