/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.concurrency.ResultConsumer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class XDebuggerTreeCreator
implements DebuggerTreeCreator<Pair<XValue, String>> {
    @NotNull
    private final Project myProject;
    private final XDebuggerEditorsProvider myProvider;
    private final XSourcePosition myPosition;
    private final XValueMarkers<?, ?> myMarkers;

    public XDebuggerTreeCreator(@NotNull Project project, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, XValueMarkers<?, ?> markers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerTreeCreator", "<init>"));
        }
        this.myProject = project;
        this.myProvider = editorsProvider;
        this.myPosition = sourcePosition;
        this.myMarkers = markers;
    }

    @Override
    @NotNull
    public Tree createTree(@NotNull Pair<XValue, String> descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerTreeCreator", "createTree"));
        }
        XDebuggerTree tree = new XDebuggerTree(this.myProject, this.myProvider, this.myPosition, "XDebugger.Inspect.Tree.Popup", this.myMarkers);
        final XValueNodeImpl root = new XValueNodeImpl(tree, null, (String)descriptor.getSecond(), (XValue)descriptor.getFirst());
        tree.setRoot(root, true);
        tree.setSelectionRow(0);
        tree.expandNodesOnLoad(new Condition<TreeNode>(){

            public boolean value(TreeNode node) {
                return node == root;
            }
        });
        XDebuggerTree xDebuggerTree = tree;
        if (xDebuggerTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerTreeCreator", "createTree"));
        }
        return xDebuggerTree;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull Pair<XValue, String> descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerTreeCreator", "getTitle"));
        }
        String string = (String)descriptor.getSecond();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerTreeCreator", "getTitle"));
        }
        return string;
    }

    @Override
    public void createDescriptorByNode(Object node, ResultConsumer<Pair<XValue, String>> resultConsumer) {
        if (node instanceof XValueNodeImpl) {
            XValueNodeImpl valueNode = (XValueNodeImpl)node;
            resultConsumer.onSuccess((Object)Pair.create(valueNode.getValueContainer(), (Object)valueNode.getName()));
        }
    }
}

