/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import org.jetbrains.annotations.NotNull;

public class ColorGetterByLayoutIndex<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final PermanentGraphInfo<CommitId> myPermanentGraphInfo;

    public ColorGetterByLayoutIndex(@NotNull LinearGraph linearGraph, @NotNull PermanentGraphInfo<CommitId> permanentGraphInfo) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/impl/print/ColorGetterByLayoutIndex", "<init>"));
        }
        if (permanentGraphInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphInfo", "com/intellij/vcs/log/graph/impl/print/ColorGetterByLayoutIndex", "<init>"));
        }
        this.myLinearGraph = linearGraph;
        this.myPermanentGraphInfo = permanentGraphInfo;
    }

    public int getColorId(@NotNull GraphElement element) {
        int downNodeIndex;
        int upNodeIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/vcs/log/graph/impl/print/ColorGetterByLayoutIndex", "getColorId"));
        }
        if (element instanceof GraphNode) {
            downNodeIndex = upNodeIndex = ((GraphNode)element).getNodeIndex();
        } else {
            GraphEdge edge = (GraphEdge)element;
            Pair<Integer, Integer> normalEdge = LinearGraphUtils.asNormalEdge(edge);
            if (normalEdge != null) {
                upNodeIndex = (Integer)normalEdge.first;
                downNodeIndex = (Integer)normalEdge.second;
            } else {
                downNodeIndex = upNodeIndex = LinearGraphUtils.getNotNullNodeIndex(edge);
            }
        }
        int upLayoutIndex = this.getLayoutIndex(upNodeIndex);
        int downLayoutIndex = this.getLayoutIndex(downNodeIndex);
        CommitId headCommitId = this.getOneOfHeads(upNodeIndex);
        GraphColorManager<CommitId> myColorManager = this.myPermanentGraphInfo.getGraphColorManager();
        if (upLayoutIndex != downLayoutIndex) {
            return myColorManager.getColorOfFragment(headCommitId, Math.max(upLayoutIndex, downLayoutIndex));
        }
        if (upLayoutIndex == this.myPermanentGraphInfo.getPermanentGraphLayout().getLayoutIndex(this.getHeadNodeId(upNodeIndex))) {
            return myColorManager.getColorOfBranch(headCommitId);
        }
        return myColorManager.getColorOfFragment(headCommitId, upLayoutIndex);
    }

    private int getHeadNodeId(int upNodeIndex) {
        int nodeId = this.getNodeId(upNodeIndex);
        if (nodeId < 0) {
            return 0;
        }
        return this.myPermanentGraphInfo.getPermanentGraphLayout().getOneOfHeadNodeIndex(nodeId);
    }

    private CommitId getOneOfHeads(int upNodeIndex) {
        return this.myPermanentGraphInfo.getPermanentCommitsInfo().getCommitId(this.getHeadNodeId(upNodeIndex));
    }

    private int getLayoutIndex(int upNodeIndex) {
        int nodeId = this.getNodeId(upNodeIndex);
        if (nodeId < 0) {
            return nodeId;
        }
        return this.myPermanentGraphInfo.getPermanentGraphLayout().getLayoutIndex(nodeId);
    }

    private int getNodeId(int upNodeIndex) {
        return this.myLinearGraph.getNodeId(upNodeIndex);
    }
}

