/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorGenerator {
    private static final Map<Integer, JBColor> ourColorMap = ContainerUtil.newHashMap();

    @NotNull
    public static JBColor getColor(int branchNumber) {
        JBColor color = ourColorMap.get(branchNumber);
        if (color == null) {
            color = ColorGenerator.calcColor(branchNumber);
            ourColorMap.put(branchNumber, color);
        }
        JBColor jBColor = color;
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/ColorGenerator", "getColor"));
        }
        return jBColor;
    }

    private static int rangeFix(int n) {
        return Math.abs(n) % 100 + 70;
    }

    @NotNull
    private static JBColor calcColor(int indexColor) {
        JBColor jBColor;
        block2: {
            int r = indexColor * 200 + 30;
            int g = indexColor * 130 + 50;
            int b = indexColor * 90 + 100;
            try {
                Color color = new Color(ColorGenerator.rangeFix(r), ColorGenerator.rangeFix(g), ColorGenerator.rangeFix(b));
                jBColor = new JBColor(color, color);
                if (jBColor != null) break block2;
            }
            catch (IllegalArgumentException a) {
                throw new IllegalArgumentException("indexColor: " + indexColor + " " + r % 256 + " " + g % 256 + " " + b % 256);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/ColorGenerator", "calcColor"));
        }
        return jBColor;
    }

    static {
        ourColorMap.put(0, JBColor.BLACK);
    }
}

