/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.FileDescriptionCachedValueProvider;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.MockDomFileDescription;
import com.intellij.util.xml.impl.StableInvocationHandler;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomManagerImpl
extends DomManager {
    private static final Key<Object> MOCK = Key.create((String)"MockElement");
    static final Key<WeakReference<DomFileElementImpl>> CACHED_FILE_ELEMENT = Key.create((String)"CACHED_FILE_ELEMENT");
    static final Key<DomFileDescription> MOCK_DESCRIPTION = Key.create((String)"MockDescription");
    static final SemKey<FileDescriptionCachedValueProvider> FILE_DESCRIPTION_KEY = SemKey.createKey((String)"FILE_DESCRIPTION_KEY", (SemKey[])new SemKey[0]);
    static final SemKey<DomInvocationHandler> DOM_HANDLER_KEY = SemKey.createKey((String)"DOM_HANDLER_KEY", (SemKey[])new SemKey[0]);
    static final SemKey<IndexedElementInvocationHandler> DOM_INDEXED_HANDLER_KEY = DOM_HANDLER_KEY.subKey("DOM_INDEXED_HANDLER_KEY", new SemKey[0]);
    static final SemKey<CollectionElementInvocationHandler> DOM_COLLECTION_HANDLER_KEY = DOM_HANDLER_KEY.subKey("DOM_COLLECTION_HANDLER_KEY", new SemKey[0]);
    static final SemKey<CollectionElementInvocationHandler> DOM_CUSTOM_HANDLER_KEY = DOM_HANDLER_KEY.subKey("DOM_CUSTOM_HANDLER_KEY", new SemKey[0]);
    static final SemKey<AttributeChildInvocationHandler> DOM_ATTRIBUTE_HANDLER_KEY = DOM_HANDLER_KEY.subKey("DOM_ATTRIBUTE_HANDLER_KEY", new SemKey[0]);
    private final EventDispatcher<DomEventListener> myListeners = EventDispatcher.create(DomEventListener.class);
    private final Project myProject;
    private final SemService mySemService;
    private final DomApplicationComponent myApplicationComponent;
    private boolean myChanging;

    public DomManagerImpl(Project project) {
        super(project);
        this.myProject = project;
        this.mySemService = SemService.getSemService((Project)project);
        this.myApplicationComponent = DomApplicationComponent.getInstance();
        final PomModel pomModel = PomManager.getModel((Project)project);
        pomModel.addModelListener(new PomModelListener(){

            public void modelChanged(PomModelEvent event) {
                if (DomManagerImpl.this.myChanging) {
                    return;
                }
                XmlChangeSet changeSet = (XmlChangeSet)event.getChangeSet(pomModel.getModelAspect(XmlAspect.class));
                if (changeSet != null) {
                    for (XmlFile file2 : changeSet.getChangedFiles()) {
                        DomFileElementImpl element = DomManagerImpl.getCachedFileElement(file2);
                        if (element == null) continue;
                        DomManagerImpl.this.fireEvent(new DomEvent(element, false));
                    }
                }
            }

            public boolean isAspectChangeInteresting(PomModelAspect aspect) {
                return aspect instanceof XmlAspect;
            }
        }, (Disposable)project);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){
            private final List<DomEvent> myDeletionEvents = new SmartList();

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/xml/impl/DomManagerImpl$2", "contentsChanged"));
                }
                if (!event.isFromSave()) {
                    DomManagerImpl.this.fireEvents(DomManagerImpl.this.calcDomChangeEvents(event.getFile()));
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/xml/impl/DomManagerImpl$2", "fileMoved"));
                }
                DomManagerImpl.this.fireEvents(DomManagerImpl.this.calcDomChangeEvents(event.getFile()));
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/xml/impl/DomManagerImpl$2", "beforeFileDeletion"));
                }
                this.myDeletionEvents.addAll(DomManagerImpl.this.calcDomChangeEvents(event.getFile()));
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/xml/impl/DomManagerImpl$2", "fileDeleted"));
                }
                if (!this.myDeletionEvents.isEmpty()) {
                    DomManagerImpl.this.fireEvents(this.myDeletionEvents);
                    this.myDeletionEvents.clear();
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/xml/impl/DomManagerImpl$2", "propertyChanged"));
                }
                VirtualFile file2 = event.getFile();
                if (!file2.isDirectory() && "name".equals(event.getPropertyName())) {
                    DomManagerImpl.this.fireEvents(DomManagerImpl.this.calcDomChangeEvents(file2));
                }
            }
        }, (Disposable)this.myProject);
    }

    public long getPsiModificationCount() {
        return PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    public <T extends DomInvocationHandler> void cacheHandler(SemKey<T> key, XmlElement element, T handler2) {
        this.mySemService.setCachedSemElement(key, (PsiElement)element, handler2);
    }

    private PsiFile getCachedPsiFile(VirtualFile file2) {
        return ((PsiManagerEx)PsiManager.getInstance((Project)this.myProject)).getFileManager().getCachedPsiFile(file2);
    }

    private List<DomEvent> calcDomChangeEvents(VirtualFile file2) {
        if (!(file2 instanceof NewVirtualFile)) {
            return Collections.emptyList();
        }
        final ArrayList events = ContainerUtil.newArrayList();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                DomFileElementImpl domElement;
                PsiFile psiFile;
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/impl/DomManagerImpl$3", "visitFile"));
                }
                if (!ProjectFileIndex.SERVICE.getInstance((Project)DomManagerImpl.this.myProject).isInContent(file2)) {
                    return false;
                }
                if (!file2.isDirectory() && StdFileTypes.XML == file2.getFileType() && (psiFile = DomManagerImpl.this.getCachedPsiFile(file2)) != null && StdFileTypes.XML.equals(psiFile.getFileType()) && psiFile instanceof XmlFile && (domElement = DomManagerImpl.getCachedFileElement((XmlFile)psiFile)) != null) {
                    events.add(new DomEvent(domElement, false));
                }
                return true;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/impl/DomManagerImpl$3", "getChildrenIterable"));
                }
                return ((NewVirtualFile)file2).getCachedChildren();
            }
        });
        return events;
    }

    public static DomManagerImpl getDomManager(Project project) {
        return (DomManagerImpl)DomManager.getDomManager((Project)project);
    }

    public void addDomEventListener(DomEventListener listener, Disposable parentDisposable) {
        this.myListeners.addListener((EventListener)listener, parentDisposable);
    }

    public final ConverterManager getConverterManager() {
        return (ConverterManager)ServiceManager.getService(ConverterManager.class);
    }

    public final ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    final void fireEvent(DomEvent event) {
        if (this.mySemService.isInsideAtomicChange()) {
            return;
        }
        this.incModificationCount();
        ((DomEventListener)this.myListeners.getMulticaster()).eventOccured(event);
    }

    private void fireEvents(Collection<DomEvent> events) {
        for (DomEvent event : events) {
            this.fireEvent(event);
        }
    }

    public final DomGenericInfo getGenericInfo(Type type) {
        return this.myApplicationComponent.getStaticGenericInfo(type);
    }

    @Nullable
    public static DomInvocationHandler getDomInvocationHandler(DomElement proxy) {
        if (proxy instanceof DomFileElement) {
            return null;
        }
        if (proxy instanceof DomInvocationHandler) {
            return (DomInvocationHandler)proxy;
        }
        InvocationHandler handler2 = AdvancedProxy.getInvocationHandler(proxy);
        if (handler2 instanceof StableInvocationHandler) {
            DomElement element = (DomElement)((StableInvocationHandler)handler2).getWrappedElement();
            return element == null ? null : DomManagerImpl.getDomInvocationHandler(element);
        }
        if (handler2 instanceof DomInvocationHandler) {
            return (DomInvocationHandler)handler2;
        }
        return null;
    }

    @NotNull
    public static DomInvocationHandler getNotNullHandler(DomElement proxy) {
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(proxy);
        if (handler2 == null) {
            throw new AssertionError((Object)("null handler for " + proxy));
        }
        DomInvocationHandler domInvocationHandler = handler2;
        if (domInvocationHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomManagerImpl", "getNotNullHandler"));
        }
        return domInvocationHandler;
    }

    public static StableInvocationHandler getStableInvocationHandler(Object proxy) {
        return (StableInvocationHandler)AdvancedProxy.getInvocationHandler(proxy);
    }

    public DomApplicationComponent getApplicationComponent() {
        return this.myApplicationComponent;
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file2, Class<T> aClass, String rootTagName) {
        if (file2.getUserData(MOCK_DESCRIPTION) == null) {
            file2.putUserData(MOCK_DESCRIPTION, new MockDomFileDescription<T>(aClass, rootTagName, file2));
            this.mySemService.clearCache();
        }
        DomFileElement fileElement = this.getFileElement(file2);
        assert (fileElement != null);
        DomFileElement domFileElement = fileElement;
        if (domFileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomManagerImpl", "getFileElement"));
        }
        return domFileElement;
    }

    @NotNull
    final <T extends DomElement> FileDescriptionCachedValueProvider<T> getOrCreateCachedValueProvider(XmlFile xmlFile) {
        FileDescriptionCachedValueProvider fileDescriptionCachedValueProvider = (FileDescriptionCachedValueProvider)this.mySemService.getSemElement(FILE_DESCRIPTION_KEY, (PsiElement)xmlFile);
        if (fileDescriptionCachedValueProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomManagerImpl", "getOrCreateCachedValueProvider"));
        }
        return fileDescriptionCachedValueProvider;
    }

    public final Set<DomFileDescription> getFileDescriptions(String rootTagName) {
        return this.myApplicationComponent.getFileDescriptions(rootTagName);
    }

    public final Set<DomFileDescription> getAcceptingOtherRootTagNameDescriptions() {
        return this.myApplicationComponent.getAcceptingOtherRootTagNameDescriptions();
    }

    @NotNull
    @NonNls
    public final String getComponentName() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomManagerImpl", "getComponentName"));
        }
        return string;
    }

    final void runChange(Runnable change) {
        boolean b = this.setChanging(true);
        try {
            change.run();
        }
        finally {
            this.setChanging(b);
        }
    }

    final boolean setChanging(boolean changing) {
        boolean oldChanging = this.myChanging;
        if (changing) assert (!oldChanging);
        this.myChanging = changing;
        return oldChanging;
    }

    @Nullable
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file2) {
        if (file2 == null) {
            return null;
        }
        if (!(file2.getFileType() instanceof DomSupportEnabled)) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null && virtualFile.isDirectory()) {
            return null;
        }
        return this.getOrCreateCachedValueProvider(file2).getFileElement();
    }

    @Nullable
    static <T extends DomElement> DomFileElementImpl<T> getCachedFileElement(@NotNull XmlFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/impl/DomManagerImpl", "getCachedFileElement"));
        }
        return (DomFileElementImpl)SoftReference.dereference((Reference)((Reference)file2.getUserData(CACHED_FILE_ELEMENT)));
    }

    @Nullable
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file2, Class<T> domClass) {
        DomFileDescription description = this.getDomFileDescription(file2);
        if (description != null && this.myApplicationComponent.assignabilityCache.isAssignable(domClass, description.getRootElementClass())) {
            return this.getFileElement(file2);
        }
        return null;
    }

    @Nullable
    public final DomElement getDomElement(XmlTag element) {
        if (this.myChanging) {
            return null;
        }
        DomInvocationHandler handler2 = this.getDomHandler((XmlElement)element);
        return handler2 != null ? handler2.getProxy() : null;
    }

    @Nullable
    public GenericAttributeValue getDomElement(XmlAttribute attribute) {
        if (this.myChanging) {
            return null;
        }
        AttributeChildInvocationHandler handler2 = (AttributeChildInvocationHandler)this.mySemService.getSemElement(DOM_ATTRIBUTE_HANDLER_KEY, (PsiElement)attribute);
        return handler2 == null ? null : (GenericAttributeValue)handler2.getProxy();
    }

    @Nullable
    public DomInvocationHandler getDomHandler(XmlElement tag) {
        if (tag == null) {
            return null;
        }
        List cached = this.mySemService.getCachedSemElements(DOM_HANDLER_KEY, (PsiElement)tag);
        if (cached != null && !cached.isEmpty()) {
            return (DomInvocationHandler)((Object)cached.get(0));
        }
        return (DomInvocationHandler)this.mySemService.getSemElement(DOM_HANDLER_KEY, (PsiElement)tag);
    }

    @Nullable
    public AbstractDomChildrenDescription findChildrenDescription(@NotNull XmlTag tag, @NotNull DomElement parent) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/util/xml/impl/DomManagerImpl", "findChildrenDescription"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/DomManagerImpl", "findChildrenDescription"));
        }
        return DomManagerImpl.findChildrenDescription(tag, DomManagerImpl.getDomInvocationHandler(parent));
    }

    static AbstractDomChildrenDescription findChildrenDescription(XmlTag tag, DomInvocationHandler parent) {
        DomGenericInfoEx info = parent.getGenericInfo();
        return info.findChildrenDescription(parent, tag.getLocalName(), tag.getNamespace(), false, tag.getName());
    }

    public final boolean isDomFile(@Nullable PsiFile file2) {
        return file2 instanceof XmlFile && this.getFileElement((XmlFile)file2) != null;
    }

    @Nullable
    public final DomFileDescription<?> getDomFileDescription(PsiElement element) {
        PsiFile psiFile;
        if (element instanceof XmlElement && (psiFile = element.getContainingFile()) instanceof XmlFile) {
            return this.getDomFileDescription((XmlFile)psiFile);
        }
        return null;
    }

    public final <T extends DomElement> T createMockElement(Class<T> aClass, Module module, boolean physical) {
        XmlFile file2 = (XmlFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("a.xml", (FileType)StdFileTypes.XML, (CharSequence)"", 0L, physical);
        file2.putUserData(MOCK_ELEMENT_MODULE, (Object)module);
        file2.putUserData(MOCK, new Object());
        return this.getFileElement(file2, (Class)aClass, "I_sincerely_hope_that_nobody_will_have_such_a_root_tag_name").getRootElement();
    }

    public final boolean isMockElement(DomElement element) {
        return DomUtil.getFile((DomElement)element).getUserData(MOCK) != null;
    }

    public final <T extends DomElement> T createStableValue(Factory<T> provider) {
        return (T)((DomElement)this.createStableValue(provider, new Condition<T>(){

            public boolean value(T t) {
                return t.isValid();
            }
        }));
    }

    public final <T> T createStableValue(Factory<T> provider, Condition<T> validator) {
        Object initial = provider.create();
        assert (initial != null);
        StableInvocationHandler<Object> handler2 = new StableInvocationHandler<Object>(initial, provider, validator);
        HashSet<Class<StableElement>> intf = new HashSet<Class<StableElement>>();
        ContainerUtil.addAll(intf, (Object[])initial.getClass().getInterfaces());
        intf.add(StableElement.class);
        return (T)AdvancedProxy.createProxy(initial.getClass().getSuperclass(), intf.toArray(new Class[intf.size()]), handler2, new Object[0]);
    }

    public final <T extends DomElement> void registerFileDescription(final DomFileDescription<T> description, Disposable parentDisposable) {
        this.registerFileDescription(description);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DomManagerImpl.this.getFileDescriptions(description.getRootTagName()).remove(description);
                DomManagerImpl.this.getAcceptingOtherRootTagNameDescriptions().remove(description);
            }
        });
    }

    public final void registerFileDescription(DomFileDescription description) {
        this.mySemService.clearCache();
        this.myApplicationComponent.registerFileDescription(description);
    }

    @NotNull
    public final DomElement getResolvingScope(GenericDomValue element) {
        DomFileDescription description = DomUtil.getFileElement((DomElement)element).getFileDescription();
        DomElement domElement = description.getResolveScope(element);
        if (domElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomManagerImpl", "getResolvingScope"));
        }
        return domElement;
    }

    @Nullable
    public final DomElement getIdentityScope(DomElement element) {
        DomFileDescription description = DomUtil.getFileElement((DomElement)element).getFileDescription();
        return description.getIdentityScope(element);
    }

    public TypeChooserManager getTypeChooserManager() {
        return this.myApplicationComponent.getTypeChooserManager();
    }

    public void performAtomicChange(@NotNull Runnable change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/util/xml/impl/DomManagerImpl", "performAtomicChange"));
        }
        this.mySemService.performAtomicChange(change);
        if (!this.mySemService.isInsideAtomicChange()) {
            this.incModificationCount();
        }
    }

    public SemService getSemService() {
        return this.mySemService;
    }
}

