/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ChangeTrackingValueContainer;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableValueContainer;
import com.intellij.util.indexing.ValueContainer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MemoryIndexStorage<Key, Value>
implements IndexStorage<Key, Value> {
    private final Map<Key, ChangeTrackingValueContainer<Value>> myMap;
    @NotNull
    private final IndexStorage<Key, Value> myBackendStorage;
    private final List<BufferingStateListener> myListeners;
    private boolean myBufferingEnabled;

    public MemoryIndexStorage(@NotNull IndexStorage<Key, Value> backend) {
        if (backend == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backend", "com/intellij/util/indexing/MemoryIndexStorage", "<init>"));
        }
        this.myMap = new HashMap<Key, ChangeTrackingValueContainer<Value>>();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myBackendStorage = backend;
    }

    @NotNull
    public IndexStorage<Key, Value> getBackendStorage() {
        IndexStorage<Key, Value> indexStorage = this.myBackendStorage;
        if (indexStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MemoryIndexStorage", "getBackendStorage"));
        }
        return indexStorage;
    }

    public void addBufferingStateListener(@NotNull BufferingStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/indexing/MemoryIndexStorage", "addBufferingStateListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeBufferingStateListener(@NotNull BufferingStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/indexing/MemoryIndexStorage", "removeBufferingStateListener"));
        }
        this.myListeners.remove(listener);
    }

    public void setBufferingEnabled(boolean enabled) {
        boolean wasEnabled = this.myBufferingEnabled;
        assert (wasEnabled != enabled);
        this.myBufferingEnabled = enabled;
        for (BufferingStateListener listener : this.myListeners) {
            listener.bufferingStateChanged(enabled);
        }
    }

    public boolean isBufferingEnabled() {
        return this.myBufferingEnabled;
    }

    public void clearMemoryMap() {
        this.myMap.clear();
    }

    public void fireMemoryStorageCleared() {
        for (BufferingStateListener listener : this.myListeners) {
            listener.memoryStorageCleared();
        }
    }

    @Override
    public void close() throws StorageException {
        this.myBackendStorage.close();
    }

    @Override
    public void clear() throws StorageException {
        this.clearMemoryMap();
        this.myBackendStorage.clear();
    }

    @Override
    public void flush() throws IOException {
        this.myBackendStorage.flush();
    }

    @Override
    @NotNull
    public Collection<Key> getKeys() throws StorageException {
        HashSet keys = new HashSet();
        this.processKeys((Processor<Key>)new CommonProcessors.CollectProcessor(keys), null, null);
        HashSet hashSet = keys;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MemoryIndexStorage", "getKeys"));
        }
        return hashSet;
    }

    @Override
    public boolean processKeys(final @NotNull Processor<Key> processor2, GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/MemoryIndexStorage", "processKeys"));
        }
        final HashSet<Key> stopList = new HashSet<Key>();
        Processor decoratingProcessor = new Processor<Key>(){

            public boolean process(Key key) {
                if (stopList.contains(key)) {
                    return true;
                }
                UpdatableValueContainer container = (UpdatableValueContainer)MemoryIndexStorage.this.myMap.get(key);
                if (container != null && container.size() == 0) {
                    return true;
                }
                return processor2.process(key);
            }
        };
        for (Key key : this.myMap.keySet()) {
            if (!decoratingProcessor.process(key)) {
                return false;
            }
            stopList.add(key);
        }
        return this.myBackendStorage.processKeys(stopList.isEmpty() && this.myMap.isEmpty() ? processor2 : decoratingProcessor, scope, idFilter);
    }

    @Override
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myBufferingEnabled) {
            this.getMemValueContainer(key).addValue(inputId, value);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.myBackendStorage.addValue(key, inputId, value);
    }

    @Override
    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/indexing/MemoryIndexStorage", "removeAllValues"));
        }
        if (this.myBufferingEnabled) {
            this.getMemValueContainer(key).removeAssociatedValue(inputId);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.myBackendStorage.removeAllValues(key, inputId);
    }

    private UpdatableValueContainer<Value> getMemValueContainer(final Key key) {
        ChangeTrackingValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer == null) {
            valueContainer = new ChangeTrackingValueContainer(new ChangeTrackingValueContainer.Initializer<Value>(){

                @Override
                public Object getLock() {
                    return this;
                }

                public ValueContainer<Value> compute() {
                    try {
                        return MemoryIndexStorage.this.myBackendStorage.read(key);
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.myMap.put(key, valueContainer);
        }
        return valueContainer;
    }

    @Override
    @NotNull
    public ValueContainer<Value> read(Key key) throws StorageException {
        ValueContainer valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            ValueContainer valueContainer2 = valueContainer;
            if (valueContainer2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MemoryIndexStorage", "read"));
            }
            return valueContainer2;
        }
        ValueContainer<Value> valueContainer3 = this.myBackendStorage.read(key);
        if (valueContainer3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/MemoryIndexStorage", "read"));
        }
        return valueContainer3;
    }

    public static interface BufferingStateListener {
        public void bufferingStateChanged(boolean var1);

        public void memoryStorageCleared();
    }
}

