/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.replace.ui.ReplacementPreviewDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

class ReplaceUsageViewContext
extends UsageViewContext {
    private final HashMap<Usage, ReplacementInfo> usage2ReplacementInfo = new HashMap();
    private final Replacer replacer = new Replacer(this.mySearchContext.getProject(), ((ReplaceConfiguration)this.myConfiguration).getOptions());

    ReplaceUsageViewContext(SearchContext context, Configuration configuration, Runnable searchStarter) {
        super(configuration, context, searchStarter);
    }

    public Replacer getReplacer() {
        return this.replacer;
    }

    public void addReplaceUsage(Usage usage, MatchResult result2) {
        this.usage2ReplacementInfo.put(usage, this.getReplacer().buildReplacement(result2));
    }

    private boolean isValid(UsageInfo2UsageAdapter info) {
        UsageInfo usageInfo = info.getUsageInfo();
        return !this.isExcluded((Usage)info) && usageInfo.getElement() != null && usageInfo.getElement().isValid();
    }

    @Override
    protected void configureActions() {
        Runnable replaceRunnable = new Runnable(){

            @Override
            public void run() {
                LocalHistoryAction labelAction = LocalHistory.getInstance().startAction(SSRBundle.message("structural.replace.title", new Object[0]));
                ReplaceUsageViewContext.this.doReplace();
                ReplaceUsageViewContext.this.getUsageView().close();
                labelAction.finish();
            }
        };
        this.getUsageView().addPerformOperationAction(replaceRunnable, "Replace All", null, SSRBundle.message("do.replace.all.button", new Object[0]));
        Runnable replaceSelected = new Runnable(){

            @Override
            public void run() {
                Set infos = ReplaceUsageViewContext.this.getUsageView().getSelectedUsages();
                if (infos == null || infos.isEmpty()) {
                    return;
                }
                LocalHistoryAction labelAction = LocalHistory.getInstance().startAction(SSRBundle.message("structural.replace.title", new Object[0]));
                for (Usage info : infos) {
                    UsageInfo2UsageAdapter usage = (UsageInfo2UsageAdapter)info;
                    if (!ReplaceUsageViewContext.this.isValid(usage)) continue;
                    ReplaceUsageViewContext.this.replaceOne(usage, false);
                }
                labelAction.finish();
                if (ReplaceUsageViewContext.this.getUsageView().getUsagesCount() > 0) {
                    for (Usage usage : ReplaceUsageViewContext.this.getUsageView().getSortedUsages()) {
                        if (ReplaceUsageViewContext.this.isExcluded(usage)) continue;
                        ReplaceUsageViewContext.this.getUsageView().selectUsages(new Usage[]{usage});
                        return;
                    }
                }
            }
        };
        this.getUsageView().addButtonToLowerPane(replaceSelected, SSRBundle.message("replace.selected.button", new Object[0]));
        Runnable previewReplacement = new Runnable(){

            @Override
            public void run() {
                UsageInfo2UsageAdapter usage;
                Set selection = ReplaceUsageViewContext.this.getUsageView().getSelectedUsages();
                if (selection != null && !selection.isEmpty() && ReplaceUsageViewContext.this.isValid(usage = (UsageInfo2UsageAdapter)selection.iterator().next())) {
                    ReplaceUsageViewContext.this.replaceOne(usage, true);
                }
            }
        };
        this.getUsageView().addButtonToLowerPane(previewReplacement, SSRBundle.message("preview.replacement.button", new Object[0]));
        super.configureActions();
    }

    private static void ensureFileWritable(UsageInfo2UsageAdapter usage) {
        VirtualFile file2 = usage.getFile();
        if (file2 != null && !file2.isWritable()) {
            ReadonlyStatusHandler.getInstance((Project)usage.getElement().getProject()).ensureFilesWritable(new VirtualFile[]{file2});
        }
    }

    private void replaceOne(UsageInfo2UsageAdapter info, boolean doConfirm) {
        boolean approved;
        ReplacementInfo replacementInfo = this.usage2ReplacementInfo.get(info);
        if (doConfirm) {
            ReplacementPreviewDialog wrapper = new ReplacementPreviewDialog(this.mySearchContext.getProject(), info.getUsageInfo(), replacementInfo.getReplacement());
            approved = wrapper.showAndGet();
        } else {
            approved = true;
        }
        if (approved) {
            ReplaceUsageViewContext.ensureFileWritable(info);
            this.getUsageView().removeUsage((Usage)info);
            this.getReplacer().replace(replacementInfo);
            if (this.getUsageView().getUsagesCount() == 0) {
                this.getUsageView().close();
            }
        }
    }

    private void doReplace() {
        List infos = this.getUsageView().getSortedUsages();
        ArrayList<ReplacementInfo> results = new ArrayList<ReplacementInfo>(infos.size());
        for (Usage info : infos) {
            UsageInfo2UsageAdapter usage = (UsageInfo2UsageAdapter)info;
            if (!this.isValid(usage)) continue;
            results.add(this.usage2ReplacementInfo.get(usage));
        }
        this.getReplacer().replaceAll(results);
    }
}

