/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class JavaReplaceHandler
extends StructuralReplaceHandler {
    private final ReplacementContext myContext;
    private PsiCodeBlock codeBlock;

    public JavaReplaceHandler(ReplacementContext context) {
        this.myContext = context;
    }

    private PsiCodeBlock getCodeBlock() throws IncorrectOperationException {
        if (this.codeBlock == null) {
            this.codeBlock = (PsiCodeBlock)MatcherImplUtil.createTreeFromText(this.myContext.getOptions().getMatchOptions().getSearchPattern(), PatternTreeContext.Block, this.myContext.getOptions().getMatchOptions().getFileType(), this.myContext.getProject())[0].getParent();
        }
        return this.codeBlock;
    }

    private static PsiElement findRealSubstitutionElement(PsiElement el) {
        if (el instanceof PsiIdentifier) {
            el = el.getParent();
        }
        if (el instanceof PsiReferenceExpression && el.getParent() instanceof PsiMethodCallExpression) {
            el = el.getParent();
        }
        if (el instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)el).getDeclaredElements()[0] instanceof PsiClass) {
            el = ((PsiDeclarationStatement)el).getDeclaredElements()[0];
        }
        return el;
    }

    private static boolean isListContext(PsiElement el) {
        PsiElement parent = el.getParent();
        return parent instanceof PsiParameterList || parent instanceof PsiExpressionList || parent instanceof PsiCodeBlock || parent instanceof PsiClass || parent instanceof PsiIfStatement && (((PsiIfStatement)parent).getThenBranch() == el || ((PsiIfStatement)parent).getElseBranch() == el) || parent instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == el;
    }

    @Nullable
    private PsiNamedElement getSymbolReplacementTarget(PsiElement el) throws IncorrectOperationException {
        PsiExpression expression;
        if (this.myContext.getOptions().getMatchOptions().getFileType() != StdFileTypes.JAVA) {
            return null;
        }
        PsiStatement[] searchStatements = this.getCodeBlock().getStatements();
        if (searchStatements.length > 0 && searchStatements[0] instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)searchStatements[0]).getExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).getQualifierExpression() == null && el instanceof PsiNamedElement) {
            return (PsiNamedElement)el;
        }
        return null;
    }

    private static PsiElement getMatchExpr(PsiElement replacement, PsiElement elementToReplace) {
        if (replacement instanceof PsiExpressionStatement && !(replacement.getLastChild() instanceof PsiJavaToken) && !(replacement.getLastChild() instanceof PsiComment)) {
            replacement = ((PsiExpressionStatement)replacement).getExpression();
        } else {
            if (replacement instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)replacement).getDeclaredElements().length == 1) {
                return ((PsiDeclarationStatement)replacement).getDeclaredElements()[0];
            }
            if (replacement instanceof PsiBlockStatement && elementToReplace instanceof PsiCodeBlock) {
                return ((PsiBlockStatement)replacement).getCodeBlock();
            }
        }
        return replacement;
    }

    private boolean isSymbolReplacement(PsiElement el) throws IncorrectOperationException {
        return this.getSymbolReplacementTarget(el) != null;
    }

    private void handleModifierList(PsiElement el, PsiElement replacement) throws IncorrectOperationException {
        Map<String, String> newNameToSearchPatternNameMap = this.myContext.getNewName2PatternNameMap();
        Map<String, PsiNamedElement> originalNamedElements = Collector.collectNamedElements(el);
        Map<String, PsiNamedElement> replacedNamedElements = Collector.collectNamedElements(replacement);
        if (originalNamedElements.size() == 0 && replacedNamedElements.size() == 0) {
            Replacer.handleComments(el, replacement, this.myContext);
            return;
        }
        Map<String, PsiNamedElement> searchedNamedElements = Collector.collectNamedElements((PsiElement)this.getCodeBlock());
        for (String name : originalNamedElements.keySet()) {
            PsiNamedElement originalNamedElement = originalNamedElements.get(name);
            PsiNamedElement replacementNamedElement = replacedNamedElements.get(name);
            String key = newNameToSearchPatternNameMap.get(name);
            if (key == null) {
                key = name;
            }
            PsiNamedElement searchNamedElement = searchedNamedElements.get(key);
            if (replacementNamedElement == null && originalNamedElements.size() == 1 && replacedNamedElements.size() == 1) {
                replacementNamedElement = replacedNamedElements.entrySet().iterator().next().getValue();
            }
            PsiDocComment comment = null;
            if (originalNamedElement instanceof PsiDocCommentOwner && (comment = ((PsiDocCommentOwner)originalNamedElement).getDocComment()) == null) {
                PsiElement prevElement = originalNamedElement.getPrevSibling();
                if (prevElement instanceof PsiWhiteSpace) {
                    prevElement = prevElement.getPrevSibling();
                }
                if (prevElement instanceof PsiComment) {
                    comment = prevElement;
                }
            }
            if (replacementNamedElement != null && searchNamedElement != null) {
                Replacer.handleComments((PsiElement)originalNamedElement, (PsiElement)replacementNamedElement, this.myContext);
            }
            if (comment != null && replacementNamedElement instanceof PsiDocCommentOwner && !(replacementNamedElement.getFirstChild() instanceof PsiDocComment)) {
                PsiElement nextSibling = comment.getNextSibling();
                PsiElement prevSibling = comment.getPrevSibling();
                replacementNamedElement.addRangeBefore((PsiElement)(prevSibling instanceof PsiWhiteSpace ? prevSibling : comment), (PsiElement)(nextSibling instanceof PsiWhiteSpace ? nextSibling : comment), replacementNamedElement.getFirstChild());
            }
            if (!(originalNamedElement instanceof PsiModifierListOwner) || !(replacementNamedElement instanceof PsiModifierListOwner)) continue;
            PsiModifierList modifierList = ((PsiModifierListOwner)originalNamedElements.get(name)).getModifierList();
            if (!(searchNamedElement instanceof PsiModifierListOwner)) continue;
            PsiModifierList modifierListOfSearchedElement = ((PsiModifierListOwner)searchNamedElement).getModifierList();
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)replacementNamedElement;
            PsiModifierList modifierListOfReplacement = modifierListOwner.getModifierList();
            if (modifierListOfSearchedElement.getTextLength() == 0 && modifierListOfReplacement.getTextLength() == 0 && modifierList.getTextLength() > 0) {
                modifierListOfReplacement.replace((PsiElement)modifierList);
                continue;
            }
            if (modifierListOfSearchedElement.getTextLength() != 0 || modifierList.getTextLength() <= 0) continue;
            PsiModifierList copy = (PsiModifierList)modifierList.copy();
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!modifierListOfReplacement.hasExplicitModifier(modifier)) continue;
                copy.setModifierProperty(modifier, true);
            }
            PsiElement anchor = copy.getFirstChild();
            for (PsiAnnotation annotation : modifierListOfReplacement.getAnnotations()) {
                copy.addBefore((PsiElement)annotation, anchor);
            }
            modifierListOfReplacement.replace((PsiElement)copy);
        }
    }

    private PsiElement handleSymbolReplacement(PsiElement replacement, PsiElement el) throws IncorrectOperationException {
        PsiNamedElement nameElement = this.getSymbolReplacementTarget(el);
        if (nameElement != null) {
            PsiElement oldReplacement = replacement;
            replacement = el.copy();
            ((PsiNamedElement)replacement).setName(oldReplacement.getText());
        }
        return replacement;
    }

    @Override
    public void replace(ReplacementInfo info, ReplaceOptions options) {
        PsiElement replacement;
        PsiElement elementToReplace = info.getMatch(0);
        if (elementToReplace == null) {
            return;
        }
        elementToReplace = JavaReplaceHandler.findRealSubstitutionElement(elementToReplace);
        PsiElement elementParent = elementToReplace.getParent();
        String replacementToMake = info.getReplacement();
        boolean listContext = JavaReplaceHandler.isListContext(elementToReplace);
        if (elementToReplace instanceof PsiAnnotation && !replacementToMake.isEmpty() && !StringUtil.startsWithChar((CharSequence)replacementToMake, (char)'@')) {
            replacementToMake = "@" + replacementToMake;
        }
        PsiElement[] statements = ReplacerUtil.createTreeForReplacement(replacementToMake, elementToReplace instanceof PsiMember && !this.isSymbolReplacement(elementToReplace) ? PatternTreeContext.Class : PatternTreeContext.Block, this.myContext);
        if (elementToReplace instanceof PsiAnnotation && statements.length == 1) {
            PsiDeclarationStatement declarationStatement;
            PsiElement firstChild;
            PsiElement statement = statements[0];
            if (statement instanceof PsiDeclarationStatement && (firstChild = (declarationStatement = (PsiDeclarationStatement)statement).getFirstChild()) instanceof PsiModifierList) {
                PsiModifierList modifierList = (PsiModifierList)firstChild;
                for (PsiElement child : modifierList.getChildren()) {
                    elementParent.addBefore(child, elementToReplace);
                }
            }
            elementToReplace.delete();
            return;
        }
        if (listContext) {
            if (statements.length > 1) {
                replacement = elementParent.addRangeBefore(statements[0], statements[statements.length - 1], elementToReplace);
                this.handleModifierList(elementToReplace, replacement);
            } else if (statements.length == 1) {
                replacement = JavaReplaceHandler.getMatchExpr(statements[0], elementToReplace);
                this.handleModifierList(elementToReplace, replacement);
                replacement = this.handleSymbolReplacement(replacement, elementToReplace);
                if (replacement instanceof PsiTryStatement) {
                    PsiTryStatement tryStatement = (PsiTryStatement)replacement;
                    List unmatchedElements = (List)elementToReplace.getUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY);
                    if (unmatchedElements != null) {
                        PsiCatchSection[] catches;
                        PsiElement firstElement = (PsiElement)unmatchedElements.get(0);
                        if (firstElement instanceof PsiResourceList) {
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, firstElement, tryStatement.getFirstChild());
                        }
                        PsiCodeBlock anchor = (catches = tryStatement.getCatchSections()).length == 0 ? tryStatement.getTryBlock() : catches[catches.length - 1];
                        for (int i = unmatchedElements.size() - 1; i >= 0; --i) {
                            PsiElement element = (PsiElement)unmatchedElements.get(i);
                            if (!(element instanceof PsiCatchSection)) continue;
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, element, (PsiElement)anchor);
                        }
                        PsiElement lastElement = (PsiElement)unmatchedElements.get(unmatchedElements.size() - 1);
                        if (lastElement instanceof PsiCodeBlock) {
                            PsiElement finallyKeyword = PsiTreeUtil.skipSiblingsBackward((PsiElement)lastElement, (Class[])new Class[]{PsiWhiteSpace.class});
                            assert (finallyKeyword != null);
                            PsiElement finallyAnchor = tryStatement.getLastChild();
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, lastElement, finallyAnchor);
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, finallyKeyword, finallyAnchor);
                        }
                    }
                }
                try {
                    PsiElement inserted = elementParent.addBefore(replacement, elementToReplace);
                    if (replacement instanceof PsiComment && (elementParent instanceof PsiIfStatement || elementParent instanceof PsiLoopStatement)) {
                        elementParent.addAfter(JavaReplaceHandler.createSemicolon(replacement), inserted);
                    }
                }
                catch (IncorrectOperationException e) {
                    elementToReplace.replace(replacement);
                }
            }
        } else if (statements.length > 0) {
            replacement = ReplacerUtil.copySpacesAndCommentsBefore(elementToReplace, statements, replacementToMake, elementParent);
            if ((replacement = JavaReplaceHandler.getMatchExpr(replacement, elementToReplace)) instanceof PsiStatement && !(replacement.getLastChild() instanceof PsiJavaToken) && !(replacement.getLastChild() instanceof PsiComment)) {
                PsiElement prevLastChildInParent = replacement.getLastChild().getPrevSibling();
                if (prevLastChildInParent != null) {
                    elementParent.addRangeBefore(replacement.getFirstChild(), prevLastChildInParent, elementToReplace);
                } else {
                    elementParent.addBefore(replacement.getFirstChild(), elementToReplace);
                }
                elementToReplace.getNode().getTreeParent().removeChild(elementToReplace.getNode());
            } else {
                PsiStatement[] searchStatements;
                this.handleModifierList(elementToReplace, replacement);
                if (replacement instanceof PsiClass && (searchStatements = this.getCodeBlock().getStatements()).length > 0 && searchStatements[0] instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)searchStatements[0]).getDeclaredElements()[0] instanceof PsiClass) {
                    PsiClass replaceClazz = (PsiClass)replacement;
                    PsiClass queryClazz = (PsiClass)((PsiDeclarationStatement)searchStatements[0]).getDeclaredElements()[0];
                    PsiClass clazz = (PsiClass)elementToReplace;
                    if (replaceClazz.getExtendsList().getTextLength() == 0 && queryClazz.getExtendsList().getTextLength() == 0 && clazz.getExtendsList().getTextLength() != 0) {
                        replaceClazz.addBefore(clazz.getExtendsList().getPrevSibling(), (PsiElement)replaceClazz.getExtendsList());
                        replaceClazz.getExtendsList().addRange(clazz.getExtendsList().getFirstChild(), clazz.getExtendsList().getLastChild());
                    }
                    if (replaceClazz.getImplementsList().getTextLength() == 0 && queryClazz.getImplementsList().getTextLength() == 0 && clazz.getImplementsList().getTextLength() != 0) {
                        replaceClazz.addBefore(clazz.getImplementsList().getPrevSibling(), (PsiElement)replaceClazz.getImplementsList());
                        replaceClazz.getImplementsList().addRange(clazz.getImplementsList().getFirstChild(), clazz.getImplementsList().getLastChild());
                    }
                    if (replaceClazz.getTypeParameterList().getTextLength() == 0 && queryClazz.getTypeParameterList().getTextLength() == 0 && clazz.getTypeParameterList().getTextLength() != 0) {
                        replaceClazz.getTypeParameterList().replace((PsiElement)clazz.getTypeParameterList());
                    }
                }
                replacement = this.handleSymbolReplacement(replacement, elementToReplace);
                elementToReplace.replace(replacement);
            }
        } else {
            PsiElement nextSibling = elementToReplace.getNextSibling();
            elementToReplace.delete();
            if (nextSibling instanceof PsiWhiteSpace && nextSibling.isValid()) {
                nextSibling.delete();
            }
        }
        if (listContext) {
            int matchSize = info.getMatchesCount();
            for (int i = 0; i < matchSize; ++i) {
                PsiElement matchElement = info.getMatch(i);
                PsiElement element = JavaReplaceHandler.findRealSubstitutionElement(matchElement);
                if (element == null) continue;
                PsiElement firstToDelete = element;
                PsiElement lastToDelete = element;
                PsiElement prevSibling = element.getPrevSibling();
                PsiElement nextSibling = element.getNextSibling();
                if (prevSibling instanceof PsiWhiteSpace) {
                    firstToDelete = prevSibling;
                    prevSibling = prevSibling.getPrevSibling();
                } else if (prevSibling == null && nextSibling instanceof PsiWhiteSpace) {
                    lastToDelete = nextSibling;
                }
                if (element instanceof PsiExpression) {
                    PsiElement parent = element.getParent().getParent();
                    if ((parent instanceof PsiCall || parent instanceof PsiAnonymousClass) && PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                        firstToDelete = prevSibling;
                    }
                } else if (element instanceof PsiParameter && PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                    firstToDelete = prevSibling;
                } else if (element instanceof PsiField) {
                    while (PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.COMMA)) {
                        lastToDelete = PsiTreeUtil.skipSiblingsForward((PsiElement)nextSibling, (Class[])new Class[]{PsiWhiteSpace.class});
                        nextSibling = PsiTreeUtil.skipSiblingsForward((PsiElement)lastToDelete, (Class[])new Class[]{PsiWhiteSpace.class});
                    }
                }
                element.getParent().deleteChildRange(firstToDelete, lastToDelete);
            }
        }
    }

    private static void addElementAfterAnchor(PsiElement parentElement, PsiElement element, PsiElement anchor) {
        parentElement.addAfter(element, anchor);
        PsiElement sibling = element.getPrevSibling();
        if (sibling instanceof PsiWhiteSpace) {
            parentElement.addAfter(sibling, anchor);
        }
    }

    @Override
    public void postProcess(PsiElement affectedElement, ReplaceOptions options) {
        if (!affectedElement.isValid()) {
            return;
        }
        if (options.isToUseStaticImport()) {
            JavaReplaceHandler.shortenWithStaticImports(affectedElement, 0, affectedElement.getTextLength());
        }
        if (options.isToShortenFQN()) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)affectedElement.getProject());
            codeStyleManager.shortenClassReferences(affectedElement, 0, affectedElement.getTextLength());
        }
    }

    private static void shortenWithStaticImports(PsiElement affectedElement, int startOffset, int endOffset) {
        int elementOffset = affectedElement.getTextOffset();
        final int finalStartOffset = startOffset + elementOffset;
        final int finalEndOffset = endOffset + elementOffset;
        final ArrayList references = new ArrayList();
        JavaRecursiveElementVisitor collector = new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                int offset = reference.getTextOffset();
                if (offset > finalEndOffset) {
                    return;
                }
                super.visitReferenceElement(reference);
                if (offset + reference.getTextLength() < finalStartOffset) {
                    return;
                }
                if (reference.getTypeParameters().length != 0) {
                    return;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiMember)) {
                    return;
                }
                PsiMember member = (PsiMember)target;
                if (!member.hasModifierProperty("static")) {
                    return;
                }
                if (reference.getQualifier() == null) {
                    return;
                }
                references.add(reference);
            }
        };
        affectedElement.accept((PsiElementVisitor)collector);
        for (PsiJavaCodeReferenceElement expression : references) {
            PsiElement qualifier;
            String name;
            String className;
            PsiMember member;
            PsiClass containingClass;
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiMember) || (containingClass = (member = (PsiMember)target).getContainingClass()) == null || (className = containingClass.getQualifiedName()) == null || (name = member.getName()) == null || !ImportUtils.addStaticImport(className, name, (PsiElement)expression) || (qualifier = expression.getQualifier()) == null) continue;
            qualifier.delete();
        }
    }

    @Nullable
    private static PsiElement createSemicolon(PsiElement space) throws IncorrectOperationException {
        PsiStatement text = JavaPsiFacade.getInstance((Project)space.getProject()).getElementFactory().createStatementFromText(";", null);
        return text.getFirstChild();
    }

    private static class Collector
    extends JavaRecursiveElementWalkingVisitor {
        private final HashMap<String, PsiNamedElement> namedElements = new HashMap(1);

        private Collector() {
        }

        public static Map<String, PsiNamedElement> collectNamedElements(PsiElement context) {
            Collector collector = new Collector();
            context.accept((PsiElementVisitor)collector);
            return collector.namedElements;
        }

        public void visitClass(PsiClass aClass) {
            if (aClass instanceof PsiAnonymousClass) {
                return;
            }
            this.handleNamedElement((PsiNamedElement)aClass);
        }

        private void handleNamedElement(PsiNamedElement named) {
            String name = named.getName();
            assert (name != null);
            if (StructuralSearchUtil.isTypedVariable(name)) {
                name = name.substring(1, name.length() - 1);
            }
            if (!this.namedElements.containsKey(name)) {
                this.namedElements.put(name, named);
            }
            named.acceptChildren((PsiElementVisitor)this);
        }

        public void visitVariable(PsiVariable var) {
            this.handleNamedElement((PsiNamedElement)var);
        }

        public void visitMethod(PsiMethod method) {
            this.handleNamedElement((PsiNamedElement)method);
        }
    }
}

