/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Factory;
import com.intellij.remoteServer.util.DeploymentNameConfiguration;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CloudDeploymentNameEditor<T extends DeploymentNameConfiguration>
extends SettingsEditor<T> {
    private JTextField myNameTextField;
    private JCheckBox myCustomNameCheckBox;
    private JPanel myMainPanel;

    public CloudDeploymentNameEditor(Factory<T> deploymentModelFactory, String labelCaption) {
        super(deploymentModelFactory);
        this.$$$setupUI$$$();
        this.myCustomNameCheckBox.setText(labelCaption);
        this.myCustomNameCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudDeploymentNameEditor.this.updateNameEnabled();
            }
        });
        this.myCustomNameCheckBox.setSelected(false);
        this.updateNameEnabled();
    }

    private void updateNameEnabled() {
        this.myNameTextField.setEnabled(this.myCustomNameCheckBox.isSelected());
    }

    public void resetEditorFrom(T settings) {
        this.myCustomNameCheckBox.setSelected(!settings.isDefaultDeploymentName());
        this.updateNameEnabled();
        this.myNameTextField.setText(settings.getDeploymentName());
    }

    public void applyEditorTo(T settings) throws ConfigurationException {
        settings.setDefaultDeploymentName(!this.myCustomNameCheckBox.isSelected());
        settings.setDeploymentName(this.myNameTextField.getText());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudDeploymentNameEditor", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCustomNameCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("<use context>");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jTextField.setEditable(true);
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 4));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

