/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;

public class ReturnStatementReturnValue
implements ReturnValue {
    public static final ReturnStatementReturnValue INSTANCE = new ReturnStatementReturnValue();

    private ReturnStatementReturnValue() {
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        return other instanceof ReturnStatementReturnValue;
    }

    @Override
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject()).getElementFactory();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)methodCallExpression.getProject());
        PsiReturnStatement returnStatement = (PsiReturnStatement)elementFactory.createStatementFromText("return x;", null);
        returnStatement = (PsiReturnStatement)styleManager.reformat((PsiElement)returnStatement);
        returnStatement.getReturnValue().replace((PsiElement)methodCallExpression);
        return returnStatement;
    }
}

