/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.ConstantMatchProvider;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesMatchProvider;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodDuplicatesHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"replace.method.code.duplicates.title");
    private static final Logger LOG = Logger.getInstance((String)("#" + MethodDuplicatesHandler.class.getName()));

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler", "isAvailableForQuickList"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler", "isAvailableForQuickList"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler", "isAvailableForQuickList"));
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return MethodDuplicatesHandler.getCannotRefactorMessage((PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class)) == null;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        final PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
        String cannotRefactorMessage = MethodDuplicatesHandler.getCannotRefactorMessage(member);
        if (cannotRefactorMessage != null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)cannotRefactorMessage);
            MethodDuplicatesHandler.showErrorMessage(message, project, editor);
            return;
        }
        final AnalysisScope scope = new AnalysisScope(file2);
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        final BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(RefactoringBundle.message((String)"replace.method.duplicates.scope.chooser.title", (Object[])new Object[]{REFACTORING_NAME}), RefactoringBundle.message((String)"replace.method.duplicates.scope.chooser.message"), project, scope, module != null ? module.getName() : null, false, AnalysisUIOptions.getInstance(project), element);
        if (dlg.showAndGet()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Locate duplicates", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$1", "run"));
                    }
                    indicator.setIndeterminate(true);
                    MethodDuplicatesHandler.invokeOnScope(project, member, dlg.getScope(AnalysisUIOptions.getInstance(project), scope, project, module));
                }
            });
        }
    }

    @Nullable
    private static String getCannotRefactorMessage(PsiMember member) {
        if (member == null) {
            return RefactoringBundle.message((String)"locate.caret.inside.a.method");
        }
        if (member instanceof PsiMethod) {
            if (((PsiMethod)member).isConstructor()) {
                return RefactoringBundle.message((String)"replace.with.method.call.does.not.work.for.constructors");
            }
            PsiCodeBlock body = ((PsiMethod)member).getBody();
            if (body == null) {
                return RefactoringBundle.message((String)"method.does.not.have.a.body", (Object[])new Object[]{member.getName()});
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return RefactoringBundle.message((String)"method.has.an.empty.body", (Object[])new Object[]{member.getName()});
            }
        } else if (member instanceof PsiField) {
            PsiField field = (PsiField)member;
            if (field.getInitializer() == null) {
                return "Field " + member.getName() + " doesn't have initializer";
            }
            PsiClass containingClass = field.getContainingClass();
            if (!field.hasModifierProperty("final") || !field.hasModifierProperty("static") || containingClass == null || containingClass.getQualifiedName() == null) {
                return "Replace Duplicates works with constants only";
            }
        } else {
            return "Caret should be inside method or constant";
        }
        return null;
    }

    public static void invokeOnScope(Project project, PsiMember member, AnalysisScope scope) {
        MethodDuplicatesHandler.invokeOnScope(project, Collections.singleton(member), scope, false);
    }

    public static void invokeOnScope(final Project project, final Set<PsiMember> members, AnalysisScope scope, boolean silent) {
        final HashMap<PsiMember, List<Match>> duplicates = new HashMap<PsiMember, List<Match>>();
        final int fileCount = scope.getFileCount();
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(false);
        }
        final HashMap memberWithModulesMap = new HashMap();
        for (final PsiMember member : members) {
            final Module module = (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

                public Module compute() {
                    return ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
                }
            });
            if (module == null) continue;
            final HashSet dependencies = new HashSet();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ModuleUtilCore.collectModulesDependsOn((Module)module, (Set)dependencies);
                }
            });
            memberWithModulesMap.put(member, dependencies);
        }
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            private int myFileCount = 0;

            public void visitFile(PsiFile file2) {
                Module targetModule;
                if (progressIndicator != null) {
                    if (progressIndicator.isCanceled()) {
                        return;
                    }
                    progressIndicator.setFraction((double)this.myFileCount++ / (double)fileCount);
                    VirtualFile virtualFile = file2.getVirtualFile();
                    if (virtualFile != null) {
                        progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                    }
                }
                if ((targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2)) == null) {
                    return;
                }
                for (Map.Entry entry : memberWithModulesMap.entrySet()) {
                    Set dependencies = (Set)entry.getValue();
                    if (dependencies == null || !dependencies.contains(targetModule)) continue;
                    PsiMember method = (PsiMember)entry.getKey();
                    List<Match> matchList = MethodDuplicatesHandler.hasDuplicates(file2, method);
                    Iterator<Match> iterator = matchList.iterator();
                    block1: while (iterator.hasNext()) {
                        Match match = iterator.next();
                        PsiElement matchStart = match.getMatchStart();
                        PsiElement matchEnd = match.getMatchEnd();
                        for (PsiMember psiMember : members) {
                            if (!PsiTreeUtil.isAncestor((PsiElement)psiMember, (PsiElement)matchStart, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)psiMember, (PsiElement)matchEnd, (boolean)false)) continue;
                            iterator.remove();
                            continue block1;
                        }
                    }
                    if (matchList.isEmpty()) continue;
                    ArrayList<Match> matches = (ArrayList<Match>)duplicates.get(method);
                    if (matches == null) {
                        matches = new ArrayList<Match>();
                        duplicates.put(method, matches);
                    }
                    matches.addAll(matchList);
                }
            }
        });
        if (duplicates.isEmpty()) {
            if (!silent) {
                Runnable nothingFoundRunnable = new Runnable(){

                    @Override
                    public void run() {
                        String message = RefactoringBundle.message((String)"idea.has.not.found.any.code.that.can.be.replaced.with.method.call", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                        Messages.showInfoMessage((Project)project, (String)message, (String)REFACTORING_NAME);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    nothingFoundRunnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(nothingFoundRunnable, ModalityState.NON_MODAL);
                }
            }
        } else {
            MethodDuplicatesHandler.replaceDuplicate(project, duplicates, members);
        }
    }

    private static void replaceDuplicate(final Project project, final Map<PsiMember, List<Match>> duplicates, final Set<PsiMember> methods) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null && progressIndicator.isCanceled()) {
            return;
        }
        Runnable replaceRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalHistoryAction a = LocalHistory.getInstance().startAction(REFACTORING_NAME);
                try {
                    for (final PsiMember member : methods) {
                        final List matches = (List)duplicates.get(member);
                        if (matches == null) continue;
                        int duplicatesNo = matches.size();
                        WindowManager.getInstance().getStatusBar(project).setInfo(MethodDuplicatesHandler.getStatusMessage(duplicatesNo));
                        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                            @Override
                            public void run() {
                                PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Runnable(){

                                    @Override
                                    public void run() {
                                        MatchProvider matchProvider = member instanceof PsiMethod ? new MethodDuplicatesMatchProvider((PsiMethod)member, matches) : new ConstantMatchProvider(member, project, matches);
                                        DuplicatesImpl.invoke(project, matchProvider);
                                    }
                                });
                            }
                        }, REFACTORING_NAME, (Object)REFACTORING_NAME);
                        WindowManager.getInstance().getStatusBar(project).setInfo("");
                    }
                }
                finally {
                    a.finish();
                }
            }
        };
        ApplicationManager.getApplication().invokeLater(replaceRunnable, ModalityState.NON_MODAL);
    }

    public static List<Match> hasDuplicates(PsiFile file2, PsiMember member) {
        DuplicatesFinder duplicatesFinder = MethodDuplicatesHandler.createDuplicatesFinder(member);
        if (duplicatesFinder == null) {
            return Collections.emptyList();
        }
        return duplicatesFinder.findDuplicates((PsiElement)file2);
    }

    @Nullable
    public static DuplicatesFinder createDuplicatesFinder(PsiMember member) {
        PsiElement[] pattern;
        VariableReturnValue matchedReturnValue = null;
        if (member instanceof PsiMethod) {
            PsiCodeBlock body = ((PsiMethod)member).getBody();
            LOG.assertTrue(body != null);
            PsiStatement[] statements = body.getStatements();
            pattern = statements;
            matchedReturnValue = null;
            if (statements.length != 1 || !(statements[0] instanceof PsiReturnStatement)) {
                PsiElement resolved;
                PsiExpression returnValue;
                PsiStatement lastStatement;
                PsiStatement psiStatement = lastStatement = statements.length > 0 ? statements[statements.length - 1] : null;
                if (lastStatement instanceof PsiReturnStatement && (returnValue = ((PsiReturnStatement)lastStatement).getReturnValue()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiVariable) {
                    pattern = new PsiElement[statements.length - 1];
                    System.arraycopy(statements, 0, pattern, 0, statements.length - 1);
                    matchedReturnValue = new VariableReturnValue((PsiVariable)resolved);
                }
            } else {
                PsiExpression returnValue = ((PsiReturnStatement)statements[0]).getReturnValue();
                if (returnValue != null) {
                    pattern = new PsiElement[]{returnValue};
                }
            }
        } else {
            pattern = new PsiElement[]{((PsiField)member).getInitializer()};
        }
        if (pattern.length == 0) {
            return null;
        }
        ArrayList inputVariables = member instanceof PsiMethod ? Arrays.asList(((PsiMethod)member).getParameterList().getParameters()) : new ArrayList();
        return new DuplicatesFinder(pattern, new InputVariables(inputVariables, member.getProject(), new LocalSearchScope(pattern), false), matchedReturnValue, new ArrayList());
    }

    static String getStatusMessage(int duplicatesNo) {
        return RefactoringBundle.message((String)"method.duplicates.found.message", (Object[])new Object[]{duplicatesNo});
    }

    private static void showErrorMessage(String message, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceMethodCodeDuplicates");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }
}

