/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractLightMethodObjectHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExtractLightMethodObjectHandler.class.getName()));

    @Nullable
    public static ExtractedData extractLightMethodObject(Project project, PsiFile file2, @NotNull PsiCodeFragment fragment, final String methodName) throws PrepareFailedException {
        ControlFlow controlFlow;
        PsiExpression expr;
        PsiElement container;
        PsiClass containingClass;
        PsiElement elementAt;
        TextRange range;
        Object originalAnchor;
        PsiElement identifier;
        PsiNameIdentifierOwner identifierOwner;
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler", "extractLightMethodObject"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement[] elements = ExtractLightMethodObjectHandler.completeToStatementArray(fragment, elementFactory);
        if (elements == null) {
            elements = CodeInsightUtil.findStatementsInRange((PsiFile)fragment, 0, fragment.getTextLength());
        }
        if (elements.length == 0) {
            return null;
        }
        PsiFile copy = PsiFileFactory.getInstance((Project)project).createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)file2.getText(), file2.getModificationStamp(), false);
        PsiElement originalContext = fragment.getContext();
        if (originalContext == null) {
            return null;
        }
        if (originalContext instanceof PsiKeyword && "private".equals(originalContext.getText()) && (identifierOwner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)originalContext, PsiNameIdentifierOwner.class)) != null && (identifier = identifierOwner.getNameIdentifier()) != null) {
            originalContext = identifier;
        }
        if ((originalAnchor = CodeInsightUtil.findElementInRange(copy, (range = originalContext.getTextRange()).getStartOffset(), range.getEndOffset(), originalContext.getClass())) == null && (elementAt = copy.findElementAt(range.getStartOffset())) != null && elementAt.getClass() == originalContext.getClass()) {
            originalAnchor = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])new Class[]{PsiWhiteSpace.class});
        }
        if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType(originalAnchor, PsiClass.class)) == null) {
            return null;
        }
        Object anchor = RefactoringUtil.getParentStatement(originalAnchor, false);
        if (anchor == null && PsiTreeUtil.getParentOfType(originalAnchor, PsiCodeBlock.class) != null) {
            anchor = originalAnchor;
        }
        if (anchor == null) {
            container = ((PsiClassInitializer)containingClass.add((PsiElement)elementFactory.createClassInitializer())).getBody();
            anchor = container.getLastChild();
        } else {
            container = anchor.getParent();
        }
        PsiElement firstElementCopy = container.addRangeBefore(elements[0], elements[elements.length - 1], anchor);
        final PsiElement[] elementsCopy = CodeInsightUtil.findStatementsInRange(copy, firstElementCopy.getTextRange().getStartOffset(), anchor.getTextRange().getStartOffset());
        if (elementsCopy.length == 0) {
            return null;
        }
        if (elementsCopy[elementsCopy.length - 1] instanceof PsiExpressionStatement && !((expr = ((PsiExpressionStatement)elementsCopy[elementsCopy.length - 1]).getExpression()) instanceof PsiAssignmentExpression)) {
            PsiType expressionType = GenericsUtil.getVariableTypeByExpressionType((PsiType)expr.getType());
            if (expressionType instanceof PsiDisjunctionType) {
                expressionType = ((PsiDisjunctionType)expressionType).getLeastUpperBound();
            }
            if (ExtractLightMethodObjectHandler.isValidVariableType(expressionType)) {
                String uniqueResultName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("result", elementsCopy[0], true);
                String statementText = expressionType.getCanonicalText() + " " + uniqueResultName + " = " + expr.getText() + ";";
                elementsCopy[elementsCopy.length - 1] = elementsCopy[elementsCopy.length - 1].replace((PsiElement)elementFactory.createStatementFromText(statementText, elementsCopy[elementsCopy.length - 1]));
            }
        }
        LOG.assertTrue(elementsCopy[0].getParent() == container, (Object)("element: " + elementsCopy[0].getText() + "; container: " + container.getText()));
        int startOffsetInContainer = elementsCopy[0].getStartOffsetInParent();
        try {
            controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(container, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false, false);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        List variables = ControlFlowUtil.getUsedVariables(controlFlow, controlFlow.getStartOffset(elementsCopy[0]), controlFlow.getEndOffset(elementsCopy[elementsCopy.length - 1]));
        variables = ContainerUtil.filter(variables, (Condition)new Condition<PsiVariable>(){

            public boolean value(PsiVariable variable) {
                PsiElement variableScope = variable instanceof PsiParameter ? ((PsiParameter)variable).getDeclarationScope() : PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
                return variableScope != null && PsiTreeUtil.isAncestor((PsiElement)variableScope, (PsiElement)elementsCopy[elementsCopy.length - 1], (boolean)false);
            }
        });
        String outputVariables = StringUtil.join((Collection)variables, (Function)new Function<PsiVariable, String>(){

            public String fun(PsiVariable variable) {
                return "\"variable: \" + " + variable.getName();
            }
        }, (String)" +");
        PsiStatement outStatement = elementFactory.createStatementFromText("System.out.println(" + outputVariables + ");", anchor);
        outStatement = (PsiStatement)container.addAfter((PsiElement)outStatement, elementsCopy[elementsCopy.length - 1]);
        copy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            private void makePublic(PsiMember method) {
                if (method.hasModifierProperty("private")) {
                    VisibilityUtil.setVisibility((PsiModifierList)method.getModifierList(), (String)"public");
                }
            }

            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                this.makePublic((PsiMember)method);
            }

            public void visitField(PsiField field) {
                super.visitField(field);
                this.makePublic((PsiMember)field);
            }
        });
        ExtractMethodObjectProcessor extractMethodObjectProcessor = new ExtractMethodObjectProcessor(project, null, elementsCopy, ""){

            @Override
            protected AbstractExtractDialog createExtractMethodObjectDialog(ExtractMethodObjectProcessor.MyExtractMethodProcessor processor2) {
                return new LightExtractMethodObjectDialog(this, methodName);
            }

            @Override
            protected boolean isFoldingApplicable() {
                return false;
            }
        };
        extractMethodObjectProcessor.getExtractProcessor().setShowErrorDialogs(false);
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = extractMethodObjectProcessor.getExtractProcessor();
        if (extractProcessor.prepare()) {
            if (extractProcessor.showDialog()) {
                PsiMethod method;
                try {
                    extractProcessor.doExtract();
                    UsageInfo[] usages = extractMethodObjectProcessor.findUsages();
                    extractMethodObjectProcessor.performRefactoring(usages);
                    extractMethodObjectProcessor.runChangeSignature();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if (extractMethodObjectProcessor.isCreateInnerClass()) {
                    extractMethodObjectProcessor.changeInstanceAccess(project);
                }
                LOG.assertTrue((method = extractMethodObjectProcessor.getMethod()) != null);
                method.delete();
            }
        } else {
            return null;
        }
        int startOffset = startOffsetInContainer + container.getTextRange().getStartOffset();
        String generatedCall = copy.getText().substring(startOffset, outStatement.getTextOffset());
        return new ExtractedData(generatedCall, (PsiClass)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)extractMethodObjectProcessor.getInnerClass()), (PsiElement)originalAnchor);
    }

    @Nullable
    private static PsiElement[] completeToStatementArray(PsiCodeFragment fragment, PsiElementFactory elementFactory) {
        PsiExpression expression = CodeInsightUtil.findExpressionInRange((PsiFile)fragment, 0, fragment.getTextLength());
        if (expression != null) {
            String completeExpressionText = null;
            if (expression instanceof PsiArrayInitializerExpression) {
                PsiType type;
                PsiExpression[] initializers = ((PsiArrayInitializerExpression)expression).getInitializers();
                if (initializers.length > 0 && (type = initializers[0].getType()) != null) {
                    completeExpressionText = "new " + type.getCanonicalText() + "[]" + expression.getText();
                }
            } else {
                completeExpressionText = expression.getText();
            }
            if (completeExpressionText != null) {
                return new PsiElement[]{elementFactory.createStatementFromText(completeExpressionText + ";", (PsiElement)expression)};
            }
        }
        return null;
    }

    private static boolean isValidVariableType(PsiType type) {
        return type instanceof PsiClassType || type instanceof PsiArrayType || type instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)type);
    }

    private static class LightExtractMethodObjectDialog
    implements AbstractExtractDialog {
        private final ExtractMethodObjectProcessor myProcessor;
        private final String myMethodName;

        public LightExtractMethodObjectDialog(ExtractMethodObjectProcessor processor2, String methodName) {
            this.myProcessor = processor2;
            this.myMethodName = methodName;
        }

        @Override
        public String getChosenMethodName() {
            return this.myMethodName;
        }

        @Override
        public VariableData[] getChosenParameters() {
            InputVariables inputVariables = this.myProcessor.getExtractProcessor().getInputVariables();
            return inputVariables.getInputVariables().toArray(new VariableData[inputVariables.getInputVariables().size()]);
        }

        @Override
        public String getVisibility() {
            return "public";
        }

        @Override
        public boolean isMakeStatic() {
            return false;
        }

        @Override
        public boolean isChainedConstructor() {
            return false;
        }

        @Override
        public PsiType getReturnType() {
            return null;
        }

        @Override
        public void show() {
        }

        @Override
        public boolean isOK() {
            return true;
        }
    }

    public static class ExtractedData {
        private final String myGeneratedCallText;
        private final PsiClass myGeneratedInnerClass;
        private final PsiElement myAnchor;

        public ExtractedData(String generatedCallText, PsiClass generatedInnerClass, PsiElement anchor) {
            this.myGeneratedCallText = generatedCallText;
            this.myGeneratedInnerClass = generatedInnerClass;
            this.myAnchor = anchor;
        }

        public PsiElement getAnchor() {
            return this.myAnchor;
        }

        public String getGeneratedCallText() {
            return this.myGeneratedCallText;
        }

        public PsiClass getGeneratedInnerClass() {
            return this.myGeneratedInnerClass;
        }
    }
}

