/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.psi.impl.source.html.HtmlScriptInjectionBlocker;
import com.intellij.psi.xml.XmlTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class HtmlScriptInjectionBlockerExtension
extends LanguageExtension<HtmlScriptInjectionBlocker> {
    private static final HtmlScriptInjectionBlockerExtension INSTANCE = new HtmlScriptInjectionBlockerExtension();

    private HtmlScriptInjectionBlockerExtension() {
        super("com.intellij.html.htmlScriptInjectionBlocker");
    }

    public static boolean isInjectionBlocked(@NotNull XmlTag xmlTag, @NotNull Language language) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/psi/impl/source/html/HtmlScriptInjectionBlockerExtension", "isInjectionBlocked"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/source/html/HtmlScriptInjectionBlockerExtension", "isInjectionBlocked"));
        }
        Set allFileLanguages = xmlTag.getContainingFile().getViewProvider().getLanguages();
        for (Language fileLanguage : allFileLanguages) {
            for (HtmlScriptInjectionBlocker blocker : INSTANCE.allForLanguage(fileLanguage)) {
                if (!blocker.isLanguageInjectionDenied(xmlTag, language)) continue;
                return true;
            }
        }
        return false;
    }
}

