/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.java.ChildAlignmentStrategyProvider;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubsequentVariablesAligner
implements ChildAlignmentStrategyProvider {
    private static final Set<IElementType> TYPES_TO_ALIGN = ContainerUtil.newHashSet((Object[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.EQ});
    private AlignmentStrategy myAlignmentStrategy;

    public SubsequentVariablesAligner() {
        this.updateAlignmentStrategy();
    }

    private void updateAlignmentStrategy() {
        this.myAlignmentStrategy = AlignmentStrategy.createAlignmentPerTypeStrategy(TYPES_TO_ALIGN, JavaElementType.LOCAL_VARIABLE, true);
    }

    @Override
    public AlignmentStrategy getNextChildStrategy(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/formatter/java/SubsequentVariablesAligner", "getNextChildStrategy"));
        }
        IElementType childType = child.getElementType();
        if (childType != JavaElementType.DECLARATION_STATEMENT || StringUtil.countNewLines((CharSequence)child.getChars()) > 0) {
            this.updateAlignmentStrategy();
            return AlignmentStrategy.getNullStrategy();
        }
        if (SubsequentVariablesAligner.isWhiteSpaceWithBlankLines(child.getTreePrev())) {
            this.updateAlignmentStrategy();
            return this.myAlignmentStrategy;
        }
        return this.myAlignmentStrategy;
    }

    private static boolean isWhiteSpaceWithBlankLines(@Nullable ASTNode node) {
        return node != null && node.getElementType() == TokenType.WHITE_SPACE && StringUtil.countNewLines((CharSequence)node.getChars()) > 1;
    }
}

