/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackageFileAction
extends AnAction {
    private static final SyncDateFormat TIME_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("h:mm:ss a"));

    public PackageFileAction() {
        super(CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]), CompilerBundle.message((String)"action.description.package.file", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent e) {
        List<VirtualFile> files;
        boolean visible = false;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null && !(files = PackageFileAction.getFilesToPackage(e, project)).isEmpty()) {
            visible = true;
            e.getPresentation().setText(files.size() == 1 ? CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]) : CompilerBundle.message((String)"action.name.package.files", (Object[])new Object[0]));
        }
        e.getPresentation().setVisible(visible);
    }

    @NotNull
    private static List<VirtualFile> getFilesToPackage(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/packaging/impl/ui/actions/PackageFileAction", "getFilesToPackage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/ui/actions/PackageFileAction", "getFilesToPackage"));
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/ui/actions/PackageFileAction", "getFilesToPackage"));
            }
            return list;
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        block0: for (VirtualFile file2 : files) {
            if (file2 == null || file2.isDirectory() || fileIndex.isUnderSourceRootOfType(file2, JavaModuleSourceRootTypes.SOURCES) && compilerManager.isCompilableFileType(file2.getFileType())) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/ui/actions/PackageFileAction", "getFilesToPackage"));
                }
                return list;
            }
            Collection<? extends Artifact> artifacts = ArtifactBySourceFileFinder.getInstance(project).findArtifacts(file2);
            for (Artifact artifact : artifacts) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                result2.add(file2);
                continue block0;
            }
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/ui/actions/PackageFileAction", "getFilesToPackage"));
        }
        return arrayList;
    }

    public void actionPerformed(AnActionEvent event) {
        final Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final List<VirtualFile> files = PackageFileAction.getFilesToPackage(event, project);
        Artifact[] allArtifacts = ArtifactManager.getInstance((Project)project).getArtifacts();
        PackageFileWorker.startPackagingFiles(project, files, allArtifacts, new Runnable(){

            @Override
            public void run() {
                PackageFileAction.setStatusText(project, files);
            }
        });
    }

    private static void setStatusText(Project project, List<VirtualFile> files) {
        if (!files.isEmpty()) {
            StringBuilder fileNames = new StringBuilder();
            for (VirtualFile file2 : files) {
                if (fileNames.length() != 0) {
                    fileNames.append(", ");
                }
                fileNames.append("'").append(file2.getName()).append("'");
            }
            String time = TIME_FORMAT.format(Clock.getTime());
            String statusText = CompilerBundle.message((String)"status.text.file.has.been.packaged", (Object[])new Object[]{files.size(), fileNames, time});
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null) {
                statusBar.setInfo(statusText);
            }
        }
    }
}

