/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPackagingElement
extends ComplexPackagingElement<LibraryPackagingElement> {
    @NonNls
    public static final String LIBRARY_NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "module-name";
    @NonNls
    public static final String LIBRARY_LEVEL_ATTRIBUTE = "level";
    private String myLevel;
    private String myLibraryName;
    private String myModuleName;

    public LibraryPackagingElement() {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
    }

    public LibraryPackagingElement(String level, String libraryName, String moduleName) {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
        this.myLevel = level;
        this.myLibraryName = libraryName;
        this.myModuleName = moduleName;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/LibraryPackagingElement", "getSubstitution"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/elements/LibraryPackagingElement", "getSubstitution"));
        }
        Library library = this.findLibrary(context);
        if (library != null) {
            VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
            ArrayList<FileCopyPackagingElement> elements = new ArrayList<FileCopyPackagingElement>();
            for (VirtualFile file2 : files) {
                String path = FileUtil.toSystemIndependentName((String)PathUtil.getLocalPath((VirtualFile)file2));
                elements.add((FileCopyPackagingElement)(file2.isDirectory() && file2.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(path) : new FileCopyPackagingElement(path)));
            }
            return elements;
        }
        return null;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        Library library = this.findLibrary(context);
        PackagingElementOutputKind packagingElementOutputKind = library != null ? LibraryPackagingElement.getKindForLibrary(library) : PackagingElementOutputKind.OTHER;
        if (packagingElementOutputKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/LibraryPackagingElement", "getFilesKind"));
        }
        return packagingElementOutputKind;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/LibraryPackagingElement", "createPresentation"));
        }
        return new LibraryElementPresentation(this.myLibraryName, this.myLevel, this.myModuleName, this.findLibrary((PackagingElementResolvingContext)context), context);
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/elements/LibraryPackagingElement", "isEqualTo"));
        }
        if (!(element instanceof LibraryPackagingElement)) {
            return false;
        }
        LibraryPackagingElement packagingElement = (LibraryPackagingElement)element;
        return this.myLevel != null && this.myLibraryName != null && this.myLevel.equals(packagingElement.getLevel()) && this.myLibraryName.equals(packagingElement.getLibraryName()) && Comparing.equal((String)this.myModuleName, (String)packagingElement.getModuleName());
    }

    public LibraryPackagingElement getState() {
        return this;
    }

    public void loadState(LibraryPackagingElement state) {
        this.myLevel = state.getLevel();
        this.myLibraryName = state.getLibraryName();
        this.myModuleName = state.getModuleName();
    }

    @Attribute(value="level")
    public String getLevel() {
        return this.myLevel;
    }

    public void setLevel(String level) {
        this.myLevel = level;
    }

    @Attribute(value="name")
    public String getLibraryName() {
        return this.myLibraryName;
    }

    public void setLibraryName(String libraryName) {
        this.myLibraryName = libraryName;
    }

    @Attribute(value="module-name")
    public String getModuleName() {
        return this.myModuleName;
    }

    public void setModuleName(String moduleName) {
        this.myModuleName = moduleName;
    }

    public String toString() {
        return "lib:" + this.myLibraryName + "(" + (this.myModuleName != null ? "module " + this.myModuleName : this.myLevel) + ")";
    }

    @Nullable
    public Library findLibrary(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/LibraryPackagingElement", "findLibrary"));
        }
        if (this.myModuleName == null) {
            return context.findLibrary(this.myLevel, this.myLibraryName);
        }
        ModulesProvider modulesProvider = context.getModulesProvider();
        Module module = modulesProvider.getModule(this.myModuleName);
        if (module != null) {
            for (OrderEntry entry : modulesProvider.getRootModel(module).getOrderEntries()) {
                String libraryName;
                LibraryOrderEntry libraryEntry;
                if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || (libraryName = libraryEntry.getLibraryName()) == null || !libraryName.equals(this.myLibraryName)) continue;
                return libraryEntry.getLibrary();
            }
        }
        return null;
    }

    public static PackagingElementOutputKind getKindForLibrary(Library library) {
        boolean containsDirectories = false;
        boolean containsJars = false;
        for (VirtualFile file2 : library.getFiles(OrderRootType.CLASSES)) {
            if (file2.isInLocalFileSystem()) {
                containsDirectories = true;
                continue;
            }
            containsJars = true;
        }
        return new PackagingElementOutputKind(containsDirectories, containsJars);
    }
}

