/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentComboLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

class ComboContentLayout
extends ContentLayout {
    ContentComboLabel myComboLabel;
    private BufferedImage myImage;

    ComboContentLayout(ToolWindowContentUi ui) {
        super(ui);
    }

    @Override
    public void init() {
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false);
        this.myComboLabel = new ContentComboLabel(this);
    }

    @Override
    public void reset() {
        this.myIdLabel = null;
        this.myComboLabel = null;
        this.myImage = null;
    }

    @Override
    public void layout() {
        Rectangle bounds = this.myUi.getBounds();
        JBDimension idSize = this.isIdVisible() ? this.myIdLabel.getPreferredSize() : JBUI.emptySize();
        int eachX = 0;
        int eachY = 0;
        this.myIdLabel.setBounds(eachX, eachY, idSize.width, bounds.height);
        Dimension comboSize = this.myComboLabel.getPreferredSize();
        int spaceLeft = bounds.width - (eachX += idSize.width) - (this.isToDrawCombo() && this.isIdVisible() ? 3 : 0);
        int width = comboSize.width;
        if (width > spaceLeft) {
            width = spaceLeft;
        }
        this.myComboLabel.setBounds(eachX, eachY, width, bounds.height);
    }

    @Override
    public int getMinimumWidth() {
        return this.myIdLabel != null ? this.myIdLabel.getPreferredSize().width : 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isToDrawCombo()) {
            return;
        }
        Rectangle r = this.myComboLabel.getBounds();
        if (UIUtil.isUnderDarcula()) {
            g.setColor(ColorUtil.toAlpha((Color)UIUtil.getLabelForeground(), (int)20));
            g.drawLine(r.width, 0, r.width, r.height);
            g.setColor(ColorUtil.toAlpha((Color)UIUtil.getBorderColor(), (int)50));
            g.drawLine(r.width - 1, 0, r.width - 1, r.height);
            return;
        }
        if (this.myImage == null || this.myImage.getHeight() != r.height || this.myImage.getWidth() != r.width) {
            this.myImage = UIUtil.createImage((int)r.width, (int)r.height, (int)2);
            Graphics2D g2d = this.myImage.createGraphics();
            GraphicsConfig c = new GraphicsConfig(g);
            c.setAntialiasing(true);
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)new Color(0, 0, 0, 10), (float)0.0f, (float)r.height, (Color)new Color(0, 0, 0, 30)));
            g2d.fillRect(0, 0, r.width, r.height);
            g2d.setColor(new Color(0, 0, 0, 60));
            g2d.drawLine(0, 0, 0, r.height);
            g2d.drawLine(r.width - 1, 0, r.width - 1, r.height);
            g2d.setColor(new Color(255, 255, 255, 80));
            g2d.drawRect(1, 0, r.width - 3, r.height - 1);
            g2d.dispose();
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myImage, (int)(this.isIdVisible() ? r.x : r.x - 2), (int)r.y, null);
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.isToDrawCombo()) {
            return;
        }
        GraphicsConfig c = new GraphicsConfig(g);
        c.setAntialiasing(true);
        Graphics2D g2d = (Graphics2D)g;
        c.restore();
    }

    @Override
    public void update() {
        this.updateIdLabel(this.myIdLabel);
        this.myComboLabel.update();
    }

    @Override
    public void rebuild() {
        this.myUi.removeAll();
        this.myUi.add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi);
        this.myUi.add(this.myComboLabel);
        ToolWindowContentUi.initMouseListeners(this.myComboLabel, this.myUi);
    }

    boolean isToDrawCombo() {
        return this.myUi.myManager.getContentCount() > 1;
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
    }

    @Override
    public boolean shouldDrawDecorations() {
        return this.isToDrawCombo();
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        int width = this.myComboLabel.getSize().width;
        listPopup.setMinimumSize(new Dimension(width, 0));
        listPopup.show(new RelativePoint((Component)this.myComboLabel, new Point(-2, this.myComboLabel.getHeight())));
    }

    @Override
    public RelativeRectangle getRectangleFor(Content content) {
        return null;
    }

    @Override
    public Component getComponentFor(Content content) {
        return null;
    }

    @Override
    public String getCloseActionName() {
        return "Close View";
    }

    @Override
    public String getCloseAllButThisActionName() {
        return "Close Other Views";
    }

    @Override
    public String getPreviousContentActionName() {
        return "Select Previous View";
    }

    @Override
    public String getNextContentActionName() {
        return "Select Next View";
    }
}

