/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingFileTreeTable;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEncodingConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private EncodingFileTreeTable myTreeView;
    private JScrollPane myTreePanel;
    private JPanel myPanel;
    private JCheckBox myTransparentNativeToAsciiCheckBox;
    private JPanel myPropertiesFilesEncodingCombo;
    private final Ref<Charset> mySelectedCharsetForPropertiesFiles;
    private final Ref<Charset> mySelectedIdeCharset;
    private final Ref<Charset> mySelectedProjectCharset;
    private JLabel myTitleLabel;
    private JPanel myIdeEncodingsListCombo;
    private JPanel myProjectEncodingListCombo;
    private ChooseFileEncodingAction myPropertiesEncodingAction;
    private ChooseFileEncodingAction myIdeEncodingAction;
    private ChooseFileEncodingAction myProjectEncodingAction;

    public FileEncodingConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "<init>"));
        }
        this.$$$setupUI$$$();
        this.mySelectedCharsetForPropertiesFiles = new Ref();
        this.mySelectedIdeCharset = new Ref();
        this.mySelectedProjectCharset = new Ref();
        this.myProject = project;
        this.myTitleLabel.setText(this.myTitleLabel.getText().replace("$productName", ApplicationNamesInfo.getInstance().getFullProductName()));
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"file.encodings.configurable", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.file.encodings";
    }

    @NotNull
    public String getId() {
        if ("File.Encoding" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getId"));
        }
        return "File.Encoding";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @NotNull
    private static ChooseFileEncodingAction installChooseEncodingCombo(@NotNull JPanel parentPanel, final @NotNull Ref<Charset> selected) {
        if (parentPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPanel", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "installChooseEncodingCombo"));
        }
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "installChooseEncodingCombo"));
        }
        ChooseFileEncodingAction myAction = new ChooseFileEncodingAction(null){

            @Override
            public void update(AnActionEvent e) {
                this.getTemplatePresentation().setEnabled(true);
                Charset charset = (Charset)selected.get();
                this.getTemplatePresentation().setText(charset == null ? IdeBundle.message((String)"encoding.name.system.default", (Object[])new Object[]{CharsetToolkit.getDefaultSystemCharset().displayName()}) : charset.displayName());
            }

            @Override
            protected void chosen(VirtualFile virtualFile, @NotNull Charset charset) {
                if (charset == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$1", "chosen"));
                }
                selected.set((Object)(charset == NO_ENCODING ? null : charset));
                this.update(null);
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup defaultActionGroup = this.createCharsetsActionGroup("<System Default>", (Charset)selected.get(), new Function<Charset, String>(){

                    public String fun(Charset charset) {
                        return "Choose encoding '" + charset + "'";
                    }
                });
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$1", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }
        };
        parentPanel.removeAll();
        Presentation templatePresentation = myAction.getTemplatePresentation();
        parentPanel.add((Component)myAction.createCustomComponent(templatePresentation), "Center");
        myAction.update(null);
        ChooseFileEncodingAction chooseFileEncodingAction = myAction;
        if (chooseFileEncodingAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "installChooseEncodingCombo"));
        }
        return chooseFileEncodingAction;
    }

    public JComponent createComponent() {
        this.myPropertiesEncodingAction = FileEncodingConfigurable.installChooseEncodingCombo(this.myPropertiesFilesEncodingCombo, this.mySelectedCharsetForPropertiesFiles);
        this.myIdeEncodingAction = FileEncodingConfigurable.installChooseEncodingCombo(this.myIdeEncodingsListCombo, this.mySelectedIdeCharset);
        this.myProjectEncodingAction = FileEncodingConfigurable.installChooseEncodingCombo(this.myProjectEncodingListCombo, this.mySelectedProjectCharset);
        this.myTreeView = new EncodingFileTreeTable(this.myProject);
        this.myTreePanel.setViewportView((Component)((Object)this.myTreeView));
        this.myTreeView.getEmptyText().setText(IdeBundle.message((String)"file.encodings.not.configured", (Object[])new Object[0]));
        return this.myPanel;
    }

    public boolean isModified() {
        Map<VirtualFile, Charset> existingMapping;
        if (this.isIdeEncodingModified()) {
            return true;
        }
        if (this.isProjectEncodingModified()) {
            return true;
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)this.myProject);
        Map editing = this.myTreeView.getValues();
        boolean same = editing.equals(existingMapping = FileEncodingConfigurable.getExistingMappingIncludingDefault(this.myProject)) && Comparing.equal((Object)encodingManager.getDefaultCharsetForPropertiesFiles(null), (Object)this.mySelectedCharsetForPropertiesFiles.get()) && encodingManager.isNative2AsciiForPropertiesFiles() == this.myTransparentNativeToAsciiCheckBox.isSelected();
        return !same;
    }

    @NotNull
    static Map<VirtualFile, Charset> getExistingMappingIncludingDefault(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getExistingMappingIncludingDefault"));
        }
        HashMap<VirtualFile, Charset> existingMapping = new HashMap<VirtualFile, Charset>();
        EncodingProjectManagerImpl encodingProjectManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)project);
        existingMapping.putAll(encodingProjectManager.getAllMappings());
        existingMapping.put(null, encodingProjectManager.getDefaultCharset());
        HashMap<VirtualFile, Charset> hashMap = existingMapping;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getExistingMappingIncludingDefault"));
        }
        return hashMap;
    }

    private boolean isIdeEncodingModified() {
        String charsetName = FileEncodingConfigurable.getSelectedCharsetName(this.mySelectedIdeCharset);
        return !charsetName.equals(EncodingManager.getInstance().getDefaultCharsetName());
    }

    private boolean isProjectEncodingModified() {
        String charsetName = FileEncodingConfigurable.getSelectedCharsetName(this.mySelectedProjectCharset);
        return !charsetName.equals(EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharsetName());
    }

    @NotNull
    private static String getSelectedCharsetName(@NotNull Ref<Charset> selectedCharset) {
        if (selectedCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedCharset", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getSelectedCharsetName"));
        }
        Charset charset = (Charset)selectedCharset.get();
        String string = charset == null ? "" : charset.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getSelectedCharsetName"));
        }
        return string;
    }

    public void apply() throws ConfigurationException {
        String projectCharsetName = FileEncodingConfigurable.getSelectedCharsetName(this.mySelectedProjectCharset);
        Map<VirtualFile, Charset> result2 = this.myTreeView.getValues();
        EncodingProjectManagerImpl encodingProjectManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        encodingProjectManager.setMapping(result2);
        encodingProjectManager.setDefaultCharsetName(projectCharsetName);
        encodingProjectManager.setDefaultCharsetForPropertiesFiles(null, (Charset)this.mySelectedCharsetForPropertiesFiles.get());
        encodingProjectManager.setNative2AsciiForPropertiesFiles(null, this.myTransparentNativeToAsciiCheckBox.isSelected());
        Charset ideCharset = (Charset)this.mySelectedIdeCharset.get();
        EncodingManager.getInstance().setDefaultCharsetName(ideCharset == null ? "" : ideCharset.name());
    }

    public void reset() {
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)this.myProject);
        this.myTreeView.reset(FileEncodingConfigurable.getExistingMappingIncludingDefault(this.myProject));
        this.myTransparentNativeToAsciiCheckBox.setSelected(encodingManager.isNative2AsciiForPropertiesFiles());
        this.mySelectedCharsetForPropertiesFiles.set((Object)encodingManager.getDefaultCharsetForPropertiesFiles(null));
        this.mySelectedIdeCharset.set((Object)(EncodingManager.getInstance().getDefaultCharsetName().isEmpty() ? null : EncodingManager.getInstance().getDefaultCharset()));
        this.mySelectedProjectCharset.set((Object)(encodingManager.getDefaultCharsetName().isEmpty() ? null : encodingManager.getDefaultCharset()));
        this.myPropertiesEncodingAction.update(null);
        this.myIdeEncodingAction.update(null);
        this.myProjectEncodingAction.update(null);
    }

    public void disposeUIResources() {
    }

    public void selectFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "selectFile"));
        }
        this.myTreeView.select(virtualFile);
    }

    private void createUIComponents() {
        this.myTreePanel = ScrollPaneFactory.createScrollPane((Component)new JBTable());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "");
        JScrollPane jScrollPane = this.myTreePanel;
        jPanel4.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Properties Files (*.properties)", (int)0, (int)0, null, null));
        this.myPropertiesFilesEncodingCombo = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.default.encoding.for.properties.files"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTransparentNativeToAsciiCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.transparent.native.to.ascii.conversion"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("IDE Encoding:");
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIdeEncodingsListCombo = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Project Encoding:");
        jPanel6.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectEncodingListCombo = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Override Encoding for Files/Directories", (int)0, (int)0, null, null));
        this.myTitleLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("encodings.dialog.caption"));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

