/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.configurable.ModuleVcsListener;
import com.intellij.openapi.vcs.configurable.VcsCommitMessageMarginConfigurable;
import com.intellij.openapi.vcs.configurable.VcsConfigurationsDialog;
import com.intellij.openapi.vcs.configurable.VcsContentAnnotationConfigurable;
import com.intellij.openapi.vcs.configurable.VcsLimitHistoryConfigurable;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurationDialog;
import com.intellij.openapi.vcs.configurable.VcsUpdateInfoScopeFilterConfigurable;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirectoryConfigurationPanel
extends JPanel
implements Configurable {
    private final Project myProject;
    private final String myProjectMessage;
    private final ProjectLevelVcsManager myVcsManager;
    private final TableView<MapInfo> myDirectoryMappingTable;
    private final ComboboxWithBrowseButton myVcsComboBox = new ComboboxWithBrowseButton();
    private final List<ModuleVcsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MyDirectoryRenderer myDirectoryRenderer;
    private final ColumnInfo<MapInfo, MapInfo> DIRECTORY;
    private final JCheckBox myBaseRevisionTexts;
    private ListTableModel<MapInfo> myModel;
    private final Map<String, VcsDescriptor> myAllVcss;
    private VcsContentAnnotationConfigurable myRecentlyChangedConfigurable;
    private final boolean myIsDisabled;
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final Map<String, VcsRootChecker> myCheckers;
    private JCheckBox myShowChangedRecursively;
    private final VcsLimitHistoryConfigurable myLimitHistory;
    private final VcsUpdateInfoScopeFilterConfigurable myScopeFilterConfig;
    private VcsCommitMessageMarginConfigurable myCommitMessageMarginConfigurable;
    private final ColumnInfo<MapInfo, String> VCS_SETTING = new ColumnInfo<MapInfo, String>(VcsBundle.message((String)"column.name.configure.vcses.vcs", (Object[])new Object[0])){

        public String valueOf(MapInfo object) {
            return object.mapping.getVcs();
        }

        public boolean isCellEditable(MapInfo info) {
            return info != MapInfo.SEPARATOR && info.type != MapInfo.Type.UNREGISTERED;
        }

        public void setValue(MapInfo o, String aValue) {
            Collection<AbstractVcs> activeVcses = VcsDirectoryConfigurationPanel.this.getActiveVcses();
            o.mapping.setVcs(aValue);
            VcsDirectoryConfigurationPanel.this.checkNotifyListeners(activeVcses);
        }

        public TableCellRenderer getRenderer(final MapInfo info) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    VcsDescriptor vcs;
                    String vcsName;
                    if (info == MapInfo.SEPARATOR) {
                        if (!selected) {
                            this.setBackground(VcsDirectoryConfigurationPanel.getUnregisteredRootBackground());
                        }
                        return;
                    }
                    if (info.type == MapInfo.Type.UNREGISTERED && !selected) {
                        this.setBackground(VcsDirectoryConfigurationPanel.getUnregisteredRootBackground());
                    }
                    String text = (vcsName = info.mapping.getVcs()).length() == 0 ? VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]) : ((vcs = (VcsDescriptor)VcsDirectoryConfigurationPanel.this.myAllVcss.get(vcsName)) != null ? vcs.getDisplayName() : VcsBundle.message((String)"unknown.vcs.presentation", (Object[])new Object[]{vcsName}));
                    this.append(text, VcsDirectoryConfigurationPanel.getAttributes(info));
                }
            };
        }

        public TableCellEditor getEditor(MapInfo o) {
            return new AbstractTableCellEditor(){

                public Object getCellEditorValue() {
                    VcsDescriptor selectedVcs = (VcsDescriptor)VcsDirectoryConfigurationPanel.this.myVcsComboBox.getComboBox().getSelectedItem();
                    return selectedVcs == null || selectedVcs.isNone() ? "" : selectedVcs.getName();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    String vcsName = (String)value;
                    VcsDirectoryConfigurationPanel.this.myVcsComboBox.getComboBox().setSelectedItem(VcsDirectoryConfigurationPanel.this.myAllVcss.get(vcsName));
                    return VcsDirectoryConfigurationPanel.this.myVcsComboBox;
                }
            };
        }

        @Nullable
        public String getMaxStringValue() {
            String maxString = null;
            for (String name : VcsDirectoryConfigurationPanel.this.myAllVcss.keySet()) {
                if (maxString != null && maxString.length() >= name.length()) continue;
                maxString = name;
            }
            return maxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }
    };

    @NotNull
    private static Color getUnregisteredRootBackground() {
        JBColor jBColor = new JBColor(UIUtil.getLabelBackground(), new Color(4540746));
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getUnregisteredRootBackground"));
        }
        return jBColor;
    }

    @NotNull
    private static SimpleTextAttributes getAttributes(@NotNull MapInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getAttributes"));
        }
        if (info == MapInfo.SEPARATOR) {
            SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(129, null);
            if (simpleTextAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getAttributes"));
            }
            return simpleTextAttributes;
        }
        if (info.type == MapInfo.Type.INVALID) {
            SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(0, (Color)JBColor.RED);
            if (simpleTextAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getAttributes"));
            }
            return simpleTextAttributes;
        }
        if (info.type == MapInfo.Type.UNREGISTERED) {
            SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(1, (Color)JBColor.GRAY);
            if (simpleTextAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getAttributes"));
            }
            return simpleTextAttributes;
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getAttributes"));
        }
        return simpleTextAttributes;
    }

    public VcsDirectoryConfigurationPanel(final Project project) {
        this.myProject = project;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myProjectMessage = XmlStringUtil.wrapInHtml((CharSequence)(StringUtil.escapeXml((String)"<Project>") + " - " + DefaultVcsRootPolicy.getInstance(this.myProject).getProjectConfigurationMessage(this.myProject).replace('\n', ' ')));
        this.myIsDisabled = this.myProject.isDefault();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VcsDescriptor[] vcsDescriptors = this.myVcsManager.getAllVcss();
        this.myAllVcss = new HashMap<String, VcsDescriptor>();
        for (VcsDescriptor vcsDescriptor : vcsDescriptors) {
            this.myAllVcss.put(vcsDescriptor.getName(), vcsDescriptor);
        }
        this.myDirectoryMappingTable = new TableView();
        this.myDirectoryMappingTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myBaseRevisionTexts = new JCheckBox("Store on shelf base revision texts for files under DVCS");
        this.myLimitHistory = new VcsLimitHistoryConfigurable(this.myProject);
        this.myScopeFilterConfig = new VcsUpdateInfoScopeFilterConfigurable(this.myProject, this.myVcsConfiguration);
        this.myCheckers = new HashMap<String, VcsRootChecker>();
        this.updateRootCheckers();
        this.setLayout(new BorderLayout());
        this.add(this.createMainComponent());
        this.myDirectoryRenderer = new MyDirectoryRenderer(this.myProject);
        this.DIRECTORY = new ColumnInfo<MapInfo, MapInfo>(VcsBundle.message((String)"column.info.configure.vcses.directory", (Object[])new Object[0])){

            public MapInfo valueOf(MapInfo mapping) {
                return mapping;
            }

            public TableCellRenderer getRenderer(MapInfo vcsDirectoryMapping) {
                return VcsDirectoryConfigurationPanel.this.myDirectoryRenderer;
            }
        };
        this.initializeModel();
        final JComboBox comboBox = this.myVcsComboBox.getComboBox();
        comboBox.setModel(VcsDirectoryConfigurationPanel.buildVcsWrappersModel(this.myProject));
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.isEditing()) {
                    VcsDirectoryConfigurationPanel.this.myDirectoryMappingTable.stopEditing();
                }
            }
        });
        this.myVcsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsDescriptor vcsWrapper = (VcsDescriptor)comboBox.getSelectedItem();
                new VcsConfigurationsDialog(project, comboBox, vcsWrapper).show();
            }
        });
        this.myDirectoryMappingTable.setRowHeight(this.myVcsComboBox.getPreferredSize().height);
        if (this.myIsDisabled) {
            this.myDirectoryMappingTable.setEnabled(false);
        }
    }

    private void updateRootCheckers() {
        VcsRootChecker[] checkers;
        this.myCheckers.clear();
        for (VcsRootChecker checker : checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME)) {
            VcsKey key = checker.getSupportedVcs();
            AbstractVcs vcs = this.myVcsManager.findVcsByName(key.getName());
            if (vcs == null) continue;
            this.myCheckers.put(key.getName(), checker);
        }
    }

    private void initializeModel() {
        ArrayList<MapInfo> mappings = new ArrayList<MapInfo>();
        for (VcsDirectoryMapping mapping : ProjectLevelVcsManager.getInstance((Project)this.myProject).getDirectoryMappings()) {
            mappings.add(MapInfo.registered(new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings()), this.isMappingValid(mapping)));
        }
        Collection<VcsRootError> errors = this.findUnregisteredRoots();
        if (!errors.isEmpty()) {
            mappings.add(MapInfo.SEPARATOR);
            for (VcsRootError error : errors) {
                mappings.add(MapInfo.unregistered(error.getMapping(), error.getVcsKey().getName()));
            }
        }
        this.myModel = new ListTableModel(new ColumnInfo[]{this.DIRECTORY, this.VCS_SETTING}, mappings, 0);
        this.myDirectoryMappingTable.setModelAndUpdateColumns(this.myModel);
        this.myRecentlyChangedConfigurable.reset();
        this.myLimitHistory.reset();
        this.myScopeFilterConfig.reset();
        this.myBaseRevisionTexts.setSelected(this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF);
        this.myShowChangedRecursively.setSelected(this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY);
        this.myCommitMessageMarginConfigurable.reset();
    }

    @NotNull
    private Collection<VcsRootError> findUnregisteredRoots() {
        List list = ContainerUtil.filter(VcsRootErrorsFinder.getInstance(this.myProject).find(), (Condition)new Condition<VcsRootError>(){

            public boolean value(VcsRootError error) {
                return error.getType() == VcsRootError.Type.UNREGISTERED_ROOT;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "findUnregisteredRoots"));
        }
        return list;
    }

    private boolean isMappingValid(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "isMappingValid"));
        }
        String vcs = mapping.getVcs();
        VcsRootChecker checker = this.myCheckers.get(vcs);
        return checker == null || (mapping.isDefaultMapping() ? checker.isRoot(this.myProject.getBasePath()) : checker.isRoot(mapping.getDirectory()));
    }

    public static DefaultComboBoxModel buildVcsWrappersModel(Project project) {
        VcsDescriptor[] vcsDescriptors = ProjectLevelVcsManager.getInstance((Project)project).getAllVcss();
        VcsDescriptor[] result2 = new VcsDescriptor[vcsDescriptors.length + 1];
        result2[0] = VcsDescriptor.createFictive();
        System.arraycopy(vcsDescriptors, 0, result2, 1, vcsDescriptors.length);
        return new DefaultComboBoxModel<VcsDescriptor>(result2);
    }

    private void addMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.add.title", (Object[])new Object[0]));
        dlg.initProjectMessage();
        if (dlg.showAndGet()) {
            VcsDirectoryMapping mapping = new VcsDirectoryMapping();
            dlg.saveToMapping(mapping);
            this.addMapping(mapping);
        }
    }

    private void addMapping(VcsDirectoryMapping mapping) {
        ArrayList<MapInfo> items = new ArrayList<MapInfo>(this.myModel.getItems());
        items.add(MapInfo.registered(new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings()), this.isMappingValid(mapping)));
        Collections.sort(items, MapInfo.COMPARATOR);
        this.myModel.setItems(items);
        this.checkNotifyListeners(this.getActiveVcses());
    }

    private void addSelectedUnregisteredMappings(List<MapInfo> infos) {
        ArrayList<MapInfo> items = new ArrayList<MapInfo>(this.myModel.getItems());
        for (MapInfo info : infos) {
            items.remove(info);
            items.add(MapInfo.registered(info.mapping, this.isMappingValid(info.mapping)));
        }
        VcsDirectoryConfigurationPanel.sortAndAddSeparatorIfNeeded(items);
        this.myModel.setItems(items);
        this.checkNotifyListeners(this.getActiveVcses());
    }

    @Contract(pure=false)
    private static void sortAndAddSeparatorIfNeeded(@NotNull List<MapInfo> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "sortAndAddSeparatorIfNeeded"));
        }
        boolean hasUnregistered = false;
        boolean hasSeparator = false;
        for (MapInfo item : items) {
            if (item.type == MapInfo.Type.UNREGISTERED) {
                hasUnregistered = true;
                continue;
            }
            if (item.type != MapInfo.Type.SEPARATOR) continue;
            hasSeparator = true;
        }
        if (!hasUnregistered && hasSeparator) {
            items.remove(MapInfo.SEPARATOR);
        } else if (hasUnregistered && !hasSeparator) {
            items.add(MapInfo.SEPARATOR);
        }
        Collections.sort(items, MapInfo.COMPARATOR);
    }

    private void editMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.remove.title", (Object[])new Object[0]));
        VcsDirectoryMapping mapping = ((MapInfo)ObjectUtils.assertNotNull((Object)this.myDirectoryMappingTable.getSelectedObject())).mapping;
        dlg.setMapping(mapping);
        if (dlg.showAndGet()) {
            dlg.saveToMapping(mapping);
            this.myModel.fireTableDataChanged();
            this.checkNotifyListeners(activeVcses);
        }
    }

    private void removeMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        ArrayList<MapInfo> mappings = new ArrayList<MapInfo>(this.myModel.getItems());
        int index = this.myDirectoryMappingTable.getSelectionModel().getMinSelectionIndex();
        Collection selection = this.myDirectoryMappingTable.getSelection();
        mappings.removeAll(selection);
        List removedValidRoots = ContainerUtil.mapNotNull((Collection)selection, (Function)new Function<MapInfo, MapInfo>(){

            public MapInfo fun(MapInfo info) {
                return info.type == MapInfo.Type.NORMAL && VcsDirectoryConfigurationPanel.this.myCheckers.get(info.mapping.getVcs()) != null ? MapInfo.unregistered(info.mapping.getDirectory(), info.mapping.getVcs()) : null;
            }
        });
        mappings.addAll(removedValidRoots);
        VcsDirectoryConfigurationPanel.sortAndAddSeparatorIfNeeded(mappings);
        this.myModel.setItems(mappings);
        if (mappings.size() > 0) {
            if (index >= mappings.size()) {
                index = mappings.size() - 1;
            }
            this.myDirectoryMappingTable.getSelectionModel().setSelectionInterval(index, index);
        }
        this.checkNotifyListeners(activeVcses);
    }

    protected JComponent createMainComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultInsets(new Insets(0, 0, 4, 10)).setDefaultWeightX(1.0).setDefaultFill(2);
        panel.add((Component)this.createMappingsTable(), gb.nextLine().next().fillCell().weighty(1.0));
        panel.add((Component)this.createProjectMappingDescription(), gb.nextLine().next());
        panel.add((Component)this.myLimitHistory.createComponent(), gb.nextLine().next());
        panel.add((Component)this.createShowRecursivelyDirtyOption(), gb.nextLine().next());
        panel.add((Component)this.createStoreBaseRevisionOption(), gb.nextLine().next());
        panel.add((Component)this.createShowChangedOption(), gb.nextLine().next());
        panel.add((Component)this.myScopeFilterConfig.createComponent(), gb.nextLine().next());
        panel.add((Component)this.createUseCommitMessageRightMargin(), gb.nextLine().next().fillCellHorizontally());
        return panel;
    }

    private JComponent createMappingsTable() {
        JPanel panelForTable = ToolbarDecorator.createDecorator(this.myDirectoryMappingTable, null).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (VcsDirectoryConfigurationPanel.this.onlyRegisteredRootsInSelection()) {
                    VcsDirectoryConfigurationPanel.this.addMapping();
                } else {
                    VcsDirectoryConfigurationPanel.this.addSelectedUnregisteredMappings(VcsDirectoryConfigurationPanel.this.getSelectedUnregisteredRoots());
                }
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VcsDirectoryConfigurationPanel.this.editMapping();
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VcsDirectoryConfigurationPanel.this.removeMapping();
                VcsDirectoryConfigurationPanel.this.updateRootCheckers();
            }
        }).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled && VcsDirectoryConfigurationPanel.this.rootsOfOneKindInSelection();
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled && VcsDirectoryConfigurationPanel.this.onlyRegisteredRootsInSelection();
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !VcsDirectoryConfigurationPanel.this.myIsDisabled && VcsDirectoryConfigurationPanel.this.onlyRegisteredRootsInSelection();
            }
        }).disableUpDownActions().createPanel();
        panelForTable.setPreferredSize(new Dimension(-1, 200));
        return panelForTable;
    }

    @NotNull
    private List<MapInfo> getSelectedUnregisteredRoots() {
        List list = ContainerUtil.filter((Collection)this.myDirectoryMappingTable.getSelection(), (Condition)new Condition<MapInfo>(){

            public boolean value(MapInfo info) {
                return info.type == MapInfo.Type.UNREGISTERED;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getSelectedUnregisteredRoots"));
        }
        return list;
    }

    private boolean rootsOfOneKindInSelection() {
        Collection selection = this.myDirectoryMappingTable.getSelection();
        if (selection.isEmpty()) {
            return true;
        }
        if (selection.size() == 1 && ((MapInfo)selection.iterator().next()).type == MapInfo.Type.SEPARATOR) {
            return false;
        }
        List<MapInfo> selectedRegisteredRoots = this.getSelectedRegisteredRoots();
        return selectedRegisteredRoots.size() == selection.size() || selectedRegisteredRoots.size() == 0;
    }

    @NotNull
    private List<MapInfo> getSelectedRegisteredRoots() {
        Collection selection = this.myDirectoryMappingTable.getSelection();
        List list = ContainerUtil.filter((Collection)selection, (Condition)new Condition<MapInfo>(){

            public boolean value(MapInfo info) {
                return info.type == MapInfo.Type.NORMAL || info.type == MapInfo.Type.INVALID;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getSelectedRegisteredRoots"));
        }
        return list;
    }

    private boolean onlyRegisteredRootsInSelection() {
        return this.getSelectedRegisteredRoots().size() == this.myDirectoryMappingTable.getSelection().size();
    }

    private JComponent createProjectMappingDescription() {
        JBLabel label = new JBLabel(this.myProjectMessage);
        label.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        label.setFontColor(UIUtil.FontColor.BRIGHTER);
        label.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        return label;
    }

    private JComponent createStoreBaseRevisionOption() {
        JBLabel noteLabel = new JBLabel("File texts bigger than 500K are not stored");
        noteLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        noteLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        noteLabel.setBorder(BorderFactory.createEmptyBorder(2, 25, 5, 0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myBaseRevisionTexts, "North");
        panel.add((Component)noteLabel, "South");
        return panel;
    }

    private JComponent createShowChangedOption() {
        this.myRecentlyChangedConfigurable = new VcsContentAnnotationConfigurable(this.myProject);
        JComponent component = this.myRecentlyChangedConfigurable.createComponent();
        assert (component != null);
        return component;
    }

    private JComponent createUseCommitMessageRightMargin() {
        this.myCommitMessageMarginConfigurable = new VcsCommitMessageMarginConfigurable(this.myProject, this.myVcsConfiguration);
        return this.myCommitMessageMarginConfigurable.createComponent();
    }

    private JComponent createShowRecursivelyDirtyOption() {
        this.myShowChangedRecursively = new JCheckBox("Show directories with changed descendants", this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY);
        return this.myShowChangedRecursively;
    }

    public void reset() {
        this.initializeModel();
    }

    public void apply() throws ConfigurationException {
        this.myVcsManager.setDirectoryMappings(this.getModelMappings());
        this.myRecentlyChangedConfigurable.apply();
        this.myLimitHistory.apply();
        this.myScopeFilterConfig.apply();
        this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF = this.myBaseRevisionTexts.isSelected();
        this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY = this.myShowChangedRecursively.isSelected();
        this.myCommitMessageMarginConfigurable.apply();
        this.initializeModel();
    }

    public boolean isModified() {
        if (this.myRecentlyChangedConfigurable.isModified()) {
            return true;
        }
        if (this.myLimitHistory.isModified()) {
            return true;
        }
        if (this.myScopeFilterConfig.isModified()) {
            return true;
        }
        if (this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF != this.myBaseRevisionTexts.isSelected()) {
            return true;
        }
        if (this.myVcsConfiguration.SHOW_DIRTY_RECURSIVELY != this.myShowChangedRecursively.isSelected()) {
            return true;
        }
        if (this.myCommitMessageMarginConfigurable.isModified()) {
            return true;
        }
        return !this.getModelMappings().equals(this.myVcsManager.getDirectoryMappings());
    }

    @NotNull
    private List<VcsDirectoryMapping> getModelMappings() {
        List list = ContainerUtil.mapNotNull((Collection)this.myModel.getItems(), (Function)new Function<MapInfo, VcsDirectoryMapping>(){

            public VcsDirectoryMapping fun(MapInfo info) {
                return info == MapInfo.SEPARATOR || info.type == MapInfo.Type.UNREGISTERED ? null : info.mapping;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel", "getModelMappings"));
        }
        return list;
    }

    public void addVcsListener(ModuleVcsListener moduleVcsListener) {
        this.myListeners.add(moduleVcsListener);
    }

    public void removeVcsListener(ModuleVcsListener moduleVcsListener) {
        this.myListeners.remove(moduleVcsListener);
    }

    private void checkNotifyListeners(Collection<AbstractVcs> oldVcses) {
        Collection<AbstractVcs> vcses = this.getActiveVcses();
        if (!vcses.equals(oldVcses)) {
            for (ModuleVcsListener listener : this.myListeners) {
                listener.activeVcsSetChanged(vcses);
            }
        }
    }

    public Collection<AbstractVcs> getActiveVcses() {
        HashSet<AbstractVcs> vcses = new HashSet<AbstractVcs>();
        for (VcsDirectoryMapping mapping : this.getModelMappings()) {
            if (mapping.getVcs().length() <= 0) continue;
            vcses.add(this.myVcsManager.findVcsByName(mapping.getVcs()));
        }
        return vcses;
    }

    @Nls
    public String getDisplayName() {
        return "Mappings";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
        this.myLimitHistory.disposeUIResources();
        this.myScopeFilterConfig.disposeUIResources();
    }

    private static class MyDirectoryRenderer
    extends ColoredTableCellRenderer {
        private final Project myProject;

        public MyDirectoryRenderer(Project project) {
            this.myProject = project;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value instanceof MapInfo) {
                MapInfo info = (MapInfo)value;
                if (!(selected || info != MapInfo.SEPARATOR && info.type != MapInfo.Type.UNREGISTERED)) {
                    this.setBackground(VcsDirectoryConfigurationPanel.getUnregisteredRootBackground());
                }
                if (info == MapInfo.SEPARATOR) {
                    this.append("Unregistered roots:", VcsDirectoryConfigurationPanel.getAttributes(info));
                    return;
                }
                if (info.mapping.isDefaultMapping()) {
                    this.append("<Project>", VcsDirectoryConfigurationPanel.getAttributes(info));
                    return;
                }
                String directory = info.mapping.getDirectory();
                VirtualFile baseDir = this.myProject.getBaseDir();
                if (baseDir != null) {
                    File directoryFile = new File(StringUtil.trimEnd((String)UriUtil.trimTrailingSlashes(directory), (String)"\\") + "/");
                    File ioBase = new File(baseDir.getPath());
                    if (directoryFile.isAbsolute() && !FileUtil.isAncestor((File)ioBase, (File)directoryFile, (boolean)false)) {
                        this.append(new File(directory).getPath(), VcsDirectoryConfigurationPanel.getAttributes(info));
                        return;
                    }
                    String relativePath = FileUtil.getRelativePath((File)ioBase, (File)directoryFile);
                    if (".".equals(relativePath) || relativePath == null) {
                        this.append(ioBase.getPath(), VcsDirectoryConfigurationPanel.getAttributes(info));
                    } else {
                        this.append(relativePath, VcsDirectoryConfigurationPanel.getAttributes(info));
                        this.append(" (" + ioBase + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        }
    }

    private static class MapInfo {
        static final MapInfo SEPARATOR = new MapInfo(new VcsDirectoryMapping("SEPARATOR", "SEP"), Type.SEPARATOR);
        static final Comparator<MapInfo> COMPARATOR = new Comparator<MapInfo>(){

            @Override
            public int compare(@NotNull MapInfo o1, @NotNull MapInfo o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo$1", "compare"));
                }
                if (o1.type.isRegistered() && o2.type.isRegistered() || o1.type == Type.UNREGISTERED && o2.type == Type.UNREGISTERED) {
                    return NewMappings.MAPPINGS_COMPARATOR.compare(o1.mapping, o2.mapping);
                }
                return o1.type.ordinal() - o2.type.ordinal();
            }
        };
        private final Type type;
        private final VcsDirectoryMapping mapping;

        static MapInfo unregistered(@NotNull String path, @NotNull String vcs) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo", "unregistered"));
            }
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo", "unregistered"));
            }
            return new MapInfo(new VcsDirectoryMapping(path, vcs), Type.UNREGISTERED);
        }

        static MapInfo registered(@NotNull VcsDirectoryMapping mapping, boolean valid) {
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo", "registered"));
            }
            return new MapInfo(mapping, valid ? Type.NORMAL : Type.INVALID);
        }

        private MapInfo(@NotNull VcsDirectoryMapping mapping, @NotNull Type type) {
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo", "<init>"));
            }
            this.mapping = mapping;
            this.type = type;
        }

        static enum Type {
            NORMAL,
            INVALID,
            SEPARATOR,
            UNREGISTERED;


            boolean isRegistered() {
                return this == NORMAL || this == INVALID;
            }
        }
    }
}

