/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CheckoutProviderEx;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JBProtocolCheckoutCommand
extends JBProtocolCommand {
    private static final String REPOSITORY_NAME_KEY = "checkout.repo";

    @Override
    @NotNull
    public String getCommandName() {
        if ("checkout" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkout/JBProtocolCheckoutCommand", "getCommandName"));
        }
        return "checkout";
    }

    @Override
    public void perform(String vcsId, Map<String, String> parameters) {
        String repository = parameters.get(REPOSITORY_NAME_KEY);
        if (StringUtil.isEmpty((String)repository)) {
            return;
        }
        for (CheckoutProvider provider : (CheckoutProvider[])CheckoutProvider.EXTENSION_POINT_NAME.getExtensions()) {
            CheckoutProviderEx providerEx;
            if (!(provider instanceof CheckoutProviderEx) || !(providerEx = (CheckoutProviderEx)provider).getVcsId().equals(vcsId)) continue;
            Project project = ProjectManager.getInstance().getDefaultProject();
            CheckoutProvider.Listener listener = ProjectLevelVcsManager.getInstance((Project)project).getCompositeCheckoutListener();
            providerEx.doCheckout(project, listener, repository);
            break;
        }
    }
}

