/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.ui.NewEditChangelistPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooserPanel
extends JPanel {
    private static final Comparator<ChangeList> CHANGE_LIST_COMPARATOR = new Comparator<ChangeList>(){

        @Override
        public int compare(ChangeList o1, ChangeList o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private JPanel myPanel;
    private JRadioButton myRbExisting;
    private JRadioButton myRbNew;
    private JComboBox myExistingListsCombo;
    private NewEditChangelistPanel myNewListPanel;
    private final NullableConsumer<String> myOkEnabledListener;
    private Project myProject;

    public ChangeListChooserPanel(Project project, @NotNull NullableConsumer<String> okEnabledListener) {
        if (okEnabledListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okEnabledListener", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myProject = project;
        this.myOkEnabledListener = okEnabledListener;
        this.$$$setupUI$$$();
        this.add((Component)this.myPanel, "Center");
        this.myRbExisting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ChangeListChooserPanel.this.updateEnabledItems();
            }
        });
    }

    public void init() {
        this.myExistingListsCombo.setRenderer(new ColoredListCellRendererWrapper(){
            private final IssueLinkRenderer myLinkRenderer;
            {
                this.myLinkRenderer = new IssueLinkRenderer(ChangeListChooserPanel.this.myProject, (SimpleColoredComponent)this);
            }

            protected void doCustomize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof LocalChangeList) {
                    String name = ((LocalChangeList)value).getName();
                    if (ChangeListChooserPanel.this.myExistingListsCombo.getWidth() == 0) {
                        name = name.length() > 10 ? name.substring(0, 7) + " .." : name;
                    } else {
                        String truncated;
                        FontMetrics fm = list.getFontMetrics(list.getFont());
                        int width = fm.stringWidth(name);
                        int listWidth = ChangeListChooserPanel.this.myExistingListsCombo.getWidth();
                        if (listWidth > 0 && width > listWidth && (truncated = CommittedChangeListRenderer.truncateDescription(name, fm, listWidth - fm.stringWidth(" ..") - 7)).length() > 5) {
                            name = truncated + " ..";
                        }
                    }
                    this.myLinkRenderer.appendTextWithLinks(name, ((LocalChangeList)value).isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.myNewListPanel.init(null);
        ComboboxSpeedSearch search = new ComboboxSpeedSearch(this.myExistingListsCombo);
        search.setComparator(new SpeedSearchComparator(true, false));
    }

    public void setChangeLists(Collection<? extends ChangeList> changeLists) {
        ArrayList<? extends ChangeList> list = new ArrayList<ChangeList>(changeLists);
        Collections.sort(list, CHANGE_LIST_COMPARATOR);
        this.myExistingListsCombo.setModel(new CollectionComboBoxModel(list, null));
    }

    public void setDefaultName(String name) {
        if (!StringUtil.isEmptyOrSpaces((String)name)) {
            this.myNewListPanel.setChangeListName(name);
        }
    }

    private void updateEnabledItems() {
        if (this.myRbExisting.isSelected()) {
            this.myExistingListsCombo.setEnabled(true);
            UIUtil.setEnabled((Component)this.myNewListPanel, (boolean)false, (boolean)true);
            this.myExistingListsCombo.requestFocus();
        } else {
            this.myExistingListsCombo.setEnabled(false);
            UIUtil.setEnabled((Component)this.myNewListPanel, (boolean)true, (boolean)true);
            this.myNewListPanel.requestFocus();
        }
        if (this.myProject != null) {
            this.myNewListPanel.nameChangedImpl(this.myProject, null);
        }
    }

    @Nullable
    public LocalChangeList getSelectedList(Project project) {
        String newText;
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        if (this.myRbNew.isSelected() && manager.findChangeList(newText = this.myNewListPanel.getChangeListName()) != null) {
            Messages.showErrorDialog((Project)project, (String)VcsBundle.message((String)"changes.newchangelist.warning.already.exists.text", (Object[])new Object[]{newText}), (String)VcsBundle.message((String)"changes.newchangelist.warning.already.exists.title", (Object[])new Object[0]));
            return null;
        }
        if (this.myRbExisting.isSelected()) {
            return (LocalChangeList)this.myExistingListsCombo.getSelectedItem();
        }
        LocalChangeList changeList = manager.addChangeList(this.myNewListPanel.getChangeListName(), this.myNewListPanel.getDescription());
        this.myNewListPanel.changelistCreatedOrChanged(changeList);
        if (this.myNewListPanel.getMakeActiveCheckBox().isSelected()) {
            manager.setDefaultChangeList(changeList);
        }
        VcsConfiguration.getInstance((Project)project).MAKE_NEW_CHANGELIST_ACTIVE = this.myNewListPanel.getMakeActiveCheckBox().isSelected();
        return changeList;
    }

    public void setDefaultSelection(ChangeList defaultSelection) {
        if (defaultSelection == null) {
            this.myExistingListsCombo.setSelectedIndex(0);
        } else {
            this.myExistingListsCombo.setSelectedItem(defaultSelection);
        }
        if (defaultSelection != null) {
            this.myRbExisting.setSelected(true);
        } else {
            this.myRbNew.setSelected(true);
        }
        this.updateEnabledItems();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRbExisting.isSelected() ? this.myExistingListsCombo : this.myNewListPanel.getPreferredFocusedComponent();
    }

    private void createUIComponents() {
        this.myNewListPanel = new NewEditChangelistPanel(this.myProject){

            @Override
            protected void nameChanged(String errorMessage) {
                if (ChangeListChooserPanel.this.myRbExisting.isSelected()) {
                    ChangeListChooserPanel.this.myOkEnabledListener.consume(null);
                } else {
                    ChangeListChooserPanel.this.myOkEnabledListener.consume((Object)errorMessage);
                }
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRbExisting = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/VcsBundle").getString("changes.changelist.chooser.existing.changelist"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbNew = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/VcsBundle").getString("changes.changelist.chooser.new.changelist"));
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExistingListsCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null, 3));
        NewEditChangelistPanel newEditChangelistPanel = this.myNewListPanel;
        jPanel.add((Component)newEditChangelistPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 7, new Dimension(300, 150), new Dimension(300, 150), null, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

