/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.AbstractIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class RecursiveFileHolder<T>
extends AbstractIgnoredFilesHolder {
    protected final FileHolder.HolderType myHolderType;
    protected final TreeMap<VirtualFile, T> myMap = new TreeMap(FilePathComparator.getInstance());
    protected final TreeMap<VirtualFile, T> myDirMap = new TreeMap(FilePathComparator.getInstance());

    public RecursiveFileHolder(Project project, FileHolder.HolderType holderType) {
        super(project);
        this.myHolderType = holderType;
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
        this.myDirMap.clear();
    }

    @Override
    protected Collection<VirtualFile> keys() {
        return this.myMap.keySet();
    }

    @Override
    public void notifyVcsStarted(AbstractVcs scope) {
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myHolderType;
    }

    @Override
    public void addFile(VirtualFile file2) {
        if (!this.containsFile(file2)) {
            this.myMap.put(file2, null);
            if (file2.isDirectory()) {
                this.myDirMap.put(file2, null);
            }
        }
    }

    @Override
    public void removeFile(VirtualFile file2) {
        this.myMap.remove(file2);
        if (file2.isDirectory()) {
            this.myDirMap.remove(file2);
        }
    }

    @Override
    public RecursiveFileHolder copy() {
        RecursiveFileHolder<T> copyHolder = new RecursiveFileHolder<T>(this.myProject, this.myHolderType);
        copyHolder.myMap.putAll(this.myMap);
        copyHolder.myDirMap.putAll(this.myDirMap);
        return copyHolder;
    }

    @Override
    public boolean containsFile(VirtualFile file2) {
        if (this.myMap.containsKey(file2)) {
            return true;
        }
        VirtualFile floor = this.myDirMap.floorKey(file2);
        if (floor == null) {
            return false;
        }
        NavigableMap<VirtualFile, T> floorMap = this.myDirMap.headMap(floor, true);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<VirtualFile> values() {
        return this.myMap.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveFileHolder that = (RecursiveFileHolder)o;
        if (this.myMap.size() != that.myMap.size()) {
            return false;
        }
        Iterator<Map.Entry<VirtualFile, T>> it1 = this.myMap.entrySet().iterator();
        Iterator<Map.Entry<VirtualFile, T>> it2 = that.myMap.entrySet().iterator();
        while (it1.hasNext()) {
            if (!it2.hasNext()) {
                return false;
            }
            Map.Entry<VirtualFile, T> next1 = it1.next();
            Map.Entry<VirtualFile, T> next2 = it2.next();
            if (Comparing.equal((Object)next1.getKey(), (Object)next2.getKey()) && Comparing.equal(next1.getValue(), next2.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }
}

