/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class DelayedNotificator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.DelayedNotificator");
    private final EventDispatcher<ChangeListListener> myDispatcher;
    private final AtomicReference<ScheduledExecutorService> myService;
    private final MyProxyDispatcher myProxyDispatcher;

    public DelayedNotificator(EventDispatcher<ChangeListListener> dispatcher, AtomicReference<ScheduledExecutorService> service) {
        this.myDispatcher = dispatcher;
        this.myService = service;
        this.myProxyDispatcher = new MyProxyDispatcher();
    }

    public void callNotify(final ChangeListCommand command) {
        this.myService.get().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    command.doNotify((EventDispatcher<ChangeListListener>)DelayedNotificator.this.myDispatcher);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        });
    }

    public ChangeListListener getProxyDispatcher() {
        return this.myProxyDispatcher;
    }

    private class MyProxyDispatcher
    implements ChangeListListener {
        private MyProxyDispatcher() {
        }

        public void changeListAdded(final ChangeList list) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListAdded(list);
                }
            });
        }

        public void changesRemoved(final Collection<Change> changes, final ChangeList fromList) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changesRemoved(changes, fromList);
                }
            });
        }

        public void changesAdded(final Collection<Change> changes, final ChangeList toList) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changesAdded(changes, toList);
                }
            });
        }

        public void changeListRemoved(final ChangeList list) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListRemoved(list);
                }
            });
        }

        public void changeListChanged(final ChangeList list) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListChanged(list);
                }
            });
        }

        public void changeListRenamed(final ChangeList list, final String oldName) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListRenamed(list, oldName);
                }
            });
        }

        public void changeListCommentChanged(final ChangeList list, final String oldComment) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListCommentChanged(list, oldComment);
                }
            });
        }

        public void changesMoved(final Collection<Change> changes, final ChangeList fromList, final ChangeList toList) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changesMoved(changes, fromList, toList);
                }
            });
        }

        public void defaultListChanged(final ChangeList oldDefaultList, final ChangeList newDefaultList) {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).defaultListChanged(oldDefaultList, newDefaultList);
                }
            });
        }

        public void unchangedFileStatusChanged() {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).unchangedFileStatusChanged();
                }
            });
        }

        public void changeListUpdateDone() {
            ((ScheduledExecutorService)DelayedNotificator.this.myService.get()).execute(new Runnable(){

                @Override
                public void run() {
                    ((ChangeListListener)DelayedNotificator.this.myDispatcher.getMulticaster()).changeListUpdateDone();
                }
            });
        }
    }
}

