/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.OperationCanceledDiffRequest;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheChangeProcessor
extends DiffRequestProcessor {
    private static final Logger LOG = Logger.getInstance(CacheChangeProcessor.class);
    @NotNull
    private final SoftHardCacheMap<Change, Pair<Change, DiffRequest>> myRequestCache;
    @Nullable
    private Change myCurrentChange;
    @NotNull
    private final DiffTaskQueue myQueue;

    public CacheChangeProcessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "<init>"));
        }
        super(project);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    public CacheChangeProcessor(@NotNull Project project, @NotNull String place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "<init>"));
        }
        super(project, place);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    @NotNull
    protected abstract List<Change> getSelectedChanges();

    @NotNull
    protected abstract List<Change> getAllChanges();

    protected abstract void selectChange(@NotNull Change var1);

    @Override
    protected void reloadRequest() {
        this.updateRequest(true, false, null);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.updateRequest(force, true, scrollToChangePolicy);
    }

    public void updateRequest(final boolean force, boolean useCache, final @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (this.isDisposed()) {
            return;
        }
        final Change change = this.myCurrentChange;
        DiffRequest cachedRequest = this.loadRequestFast(change, useCache);
        if (cachedRequest != null) {
            this.applyRequest(cachedRequest, force, scrollToChangePolicy);
            return;
        }
        this.myQueue.executeAndTryWait(new Function<ProgressIndicator, Runnable>(){

            public Runnable fun(ProgressIndicator indicator) {
                final DiffRequest request = CacheChangeProcessor.this.loadRequest(change, indicator);
                return new Runnable(){

                    @Override
                    public void run() {
                        CacheChangeProcessor.this.myRequestCache.put(change, Pair.create((Object)change, (Object)request));
                        CacheChangeProcessor.this.applyRequest(request, force, scrollToChangePolicy);
                    }
                };
            }
        }, new Runnable(){

            @Override
            public void run() {
                CacheChangeProcessor.this.applyRequest((DiffRequest)new LoadingDiffRequest(ChangeDiffRequestProducer.getRequestTitle(change)), force, scrollToChangePolicy);
            }
        }, 300);
    }

    @Nullable
    @Contract(value="null, _ -> !null")
    protected DiffRequest loadRequestFast(@Nullable Change change, boolean useCache) {
        Change oldChange;
        Pair<Change, DiffRequest> pair;
        if (change == null) {
            return NoDiffRequest.INSTANCE;
        }
        if (useCache && (pair = this.myRequestCache.get(change)) != null && ChangeDiffRequestProducer.isEquals(oldChange = (Change)pair.first, change)) {
            return (DiffRequest)pair.second;
        }
        if (change.getBeforeRevision() instanceof FakeRevision || change.getAfterRevision() instanceof FakeRevision) {
            return new LoadingDiffRequest(ChangeDiffRequestProducer.getRequestTitle(change));
        }
        return null;
    }

    @NotNull
    private DiffRequest loadRequest(@NotNull Change change, @NotNull ProgressIndicator indicator) {
        DiffRequest diffRequest;
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "loadRequest"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "loadRequest"));
        }
        ChangeDiffRequestProducer presentable = ChangeDiffRequestProducer.create(this.getProject(), change);
        if (presentable == null) {
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest("Can't show diff");
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "loadRequest"));
            }
            return errorDiffRequest;
        }
        try {
            diffRequest = presentable.process((UserDataHolder)this.getContext(), indicator);
        }
        catch (ProcessCanceledException e) {
            OperationCanceledDiffRequest request = new OperationCanceledDiffRequest(presentable.getName());
            request.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new ReloadRequestAction(change)));
            OperationCanceledDiffRequest operationCanceledDiffRequest = request;
            if (operationCanceledDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "loadRequest"));
            }
            return operationCanceledDiffRequest;
        }
        catch (DiffRequestProducerException e) {
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((DiffRequestProducer)presentable, (Throwable)e);
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "loadRequest"));
            }
            return errorDiffRequest;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((DiffRequestProducer)presentable, (Throwable)e);
            if (errorDiffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "loadRequest"));
            }
            return errorDiffRequest;
        }
        if (diffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "loadRequest"));
        }
        return diffRequest;
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.myQueue.abort();
        this.myRequestCache.clear();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = super.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/CacheChangeProcessor", "getProject"));
        }
        return project;
    }

    public void clear() {
        this.myCurrentChange = null;
        this.updateRequest();
    }

    public void refresh() {
        Change selectedChange;
        List<Change> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            this.myCurrentChange = null;
            this.updateRequest();
            return;
        }
        Change change = selectedChange = this.myCurrentChange != null ? (Change)ContainerUtil.find(selectedChanges, (Object)this.myCurrentChange) : null;
        if (selectedChange == null) {
            this.myCurrentChange = selectedChanges.get(0);
            this.updateRequest();
            return;
        }
        if (!ChangeDiffRequestProducer.isEquals(this.myCurrentChange, selectedChange)) {
            this.myCurrentChange = selectedChange;
            this.updateRequest();
        }
    }

    @Override
    protected boolean hasNextChange() {
        if (this.myCurrentChange == null) {
            return false;
        }
        List<Change> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            return false;
        }
        if (selectedChanges.size() > 1) {
            int index = selectedChanges.indexOf(this.myCurrentChange);
            return index != -1 && index < selectedChanges.size() - 1;
        }
        List<Change> allChanges = this.getAllChanges();
        int index = allChanges.indexOf(this.myCurrentChange);
        return index != -1 && index < allChanges.size() - 1;
    }

    @Override
    protected boolean hasPrevChange() {
        if (this.myCurrentChange == null) {
            return false;
        }
        List<Change> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            return false;
        }
        if (selectedChanges.size() > 1) {
            int index = selectedChanges.indexOf(this.myCurrentChange);
            return index != -1 && index > 0;
        }
        List<Change> allChanges = this.getAllChanges();
        int index = allChanges.indexOf(this.myCurrentChange);
        return index != -1 && index > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        List<Change> selectedChanges = this.getSelectedChanges();
        List<Change> allChanges = this.getAllChanges();
        if (selectedChanges.size() > 1) {
            int index = selectedChanges.indexOf(this.myCurrentChange);
            this.myCurrentChange = selectedChanges.get(index + 1);
        } else {
            int index = allChanges.indexOf(this.myCurrentChange);
            this.myCurrentChange = allChanges.get(index + 1);
            this.selectChange(this.myCurrentChange);
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        List<Change> selectedChanges = this.getSelectedChanges();
        List<Change> allChanges = this.getAllChanges();
        if (selectedChanges.size() > 1) {
            int index = selectedChanges.indexOf(this.myCurrentChange);
            this.myCurrentChange = selectedChanges.get(index - 1);
        } else {
            int index = allChanges.indexOf(this.myCurrentChange);
            this.myCurrentChange = allChanges.get(index - 1);
            this.selectChange(this.myCurrentChange);
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.getSelectedChanges().size() > 1 || this.getAllChanges().size() > 1;
    }

    protected class ReloadRequestAction
    extends DumbAwareAction {
        @NotNull
        private final Change myChange;

        public ReloadRequestAction(Change change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/CacheChangeProcessor$ReloadRequestAction", "<init>"));
            }
            super("Reload", null, AllIcons.Actions.Refresh);
            this.myChange = change;
        }

        public void actionPerformed(AnActionEvent e) {
            CacheChangeProcessor.this.myRequestCache.remove(this.myChange);
            CacheChangeProcessor.this.updateRequest(true);
        }
    }
}

