/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginHeaderPanel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class DetectedPluginsPanel
extends OrderPanel<PluginDownloader> {
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private JEditorPane myDescriptionPanel = new JEditorPane();
    private PluginHeaderPanel myHeader;

    public DetectedPluginsPanel() {
        super(PluginDownloader.class);
        final JTable entryTable = this.getEntryTable();
        this.myHeader = new PluginHeaderPanel(null);
        entryTable.setTableHeader(null);
        entryTable.setDefaultRenderer(PluginDownloader.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                this.setBorder(null);
                PluginDownloader downloader = (PluginDownloader)value;
                if (downloader != null) {
                    String loadedVersion;
                    String oldPluginName;
                    String pluginName = downloader.getPluginName();
                    this.append(pluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin(PluginId.getId((String)downloader.getPluginId()));
                    if (ideaPluginDescriptor != null && !Comparing.strEqual((String)pluginName, (String)(oldPluginName = ideaPluginDescriptor.getName()))) {
                        this.append(" - " + oldPluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    if ((loadedVersion = downloader.getPluginVersion()) != null || ideaPluginDescriptor != null && ideaPluginDescriptor.getVersion() != null) {
                        String installedVersion = ideaPluginDescriptor != null && ideaPluginDescriptor.getVersion() != null ? "v. " + ideaPluginDescriptor.getVersion() + (loadedVersion != null ? " -> " : "") : "";
                        String availableVersion = loadedVersion != null ? loadedVersion : "";
                        this.append(" (" + installedVersion + availableVersion + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            }
        });
        entryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PluginDownloader selection;
                IdeaPluginDescriptor descriptor;
                int selectedRow = entryTable.getSelectedRow();
                if (selectedRow != -1 && (descriptor = (selection = (PluginDownloader)DetectedPluginsPanel.this.getValueAt(selectedRow)).getDescriptor()) != null) {
                    PluginManagerMain.pluginInfoUpdate(descriptor, null, DetectedPluginsPanel.this.myDescriptionPanel, DetectedPluginsPanel.this.myHeader);
                }
            }
        });
        this.setCheckboxColumnName("");
        this.myDescriptionPanel.setPreferredSize(new Dimension(400, -1));
        this.myDescriptionPanel.setEditable(false);
        this.myDescriptionPanel.setContentType("text/html");
        this.myDescriptionPanel.addHyperlinkListener(new PluginManagerMain.MyHyperlinkListener());
        this.removeAll();
        Splitter splitter = new Splitter(false);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)entryTable));
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myDescriptionPanel));
        this.add((Component)splitter, "Center");
    }

    public String getCheckboxColumnName() {
        return "";
    }

    public boolean isCheckable(PluginDownloader downloader) {
        return true;
    }

    public boolean isChecked(PluginDownloader downloader) {
        return !this.getSkippedPlugins().contains(downloader.getPluginId());
    }

    public void setChecked(PluginDownloader downloader, boolean checked) {
        if (checked) {
            this.getSkippedPlugins().remove(downloader.getPluginId());
        } else {
            this.getSkippedPlugins().add(downloader.getPluginId());
        }
        for (Listener listener : this.myListeners) {
            listener.stateChanged();
        }
    }

    protected Set<String> getSkippedPlugins() {
        return UpdateChecker.getDisabledToUpdatePlugins();
    }

    public void addStateListener(Listener l) {
        this.myListeners.add(l);
    }

    public static interface Listener {
        public void stateChanged();
    }
}

