/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckForUpdateResult {
    private final BuildInfo myNewBuildInSelectedChannel;
    private final UpdateChannel myUpdatedChannel;
    private final UpdateChannel myChannelToPropose;
    private final List<String> myAllChannelIds;
    private final UpdateStrategy.State myState;
    private final Exception myError;

    public CheckForUpdateResult(@Nullable BuildInfo newBuildInSelectedChannel, @Nullable UpdateChannel updated, @Nullable UpdateChannel channelToPropose, @NotNull List<String> allChannelsIds) {
        if (allChannelsIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allChannelsIds", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "<init>"));
        }
        this.myNewBuildInSelectedChannel = newBuildInSelectedChannel;
        this.myUpdatedChannel = updated;
        this.myChannelToPropose = channelToPropose;
        this.myAllChannelIds = allChannelsIds;
        this.myState = UpdateStrategy.State.LOADED;
        this.myError = null;
    }

    public CheckForUpdateResult(@NotNull UpdateStrategy.State state, @Nullable Exception e) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "<init>"));
        }
        this.myNewBuildInSelectedChannel = null;
        this.myUpdatedChannel = null;
        this.myChannelToPropose = null;
        this.myAllChannelIds = Collections.emptyList();
        this.myState = state;
        this.myError = e;
    }

    @Nullable
    public BuildInfo getNewBuildInSelectedChannel() {
        return this.myNewBuildInSelectedChannel;
    }

    @Nullable
    public UpdateChannel getUpdatedChannel() {
        return this.myUpdatedChannel;
    }

    @Nullable
    public UpdateChannel getChannelToPropose() {
        return this.myChannelToPropose;
    }

    @NotNull
    public List<String> getAllChannelsIds() {
        List<String> list = this.myAllChannelIds;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "getAllChannelsIds"));
        }
        return list;
    }

    @NotNull
    public UpdateStrategy.State getState() {
        UpdateStrategy.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/CheckForUpdateResult", "getState"));
        }
        return state;
    }

    @Nullable
    public Exception getError() {
        return this.myError;
    }
}

