/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

public class ExcludedRootElement
extends LibraryTableTreeContentElement<ExcludedRootElement> {
    @NotNull
    private final String myUrl;

    public ExcludedRootElement(@NotNull NodeDescriptor parentDescriptor, String rootUrl, @NotNull String excludedUrl) {
        String relativePath;
        if (parentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDescriptor", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ExcludedRootElement", "<init>"));
        }
        if (excludedUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedUrl", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ExcludedRootElement", "<init>"));
        }
        super(parentDescriptor);
        this.myUrl = excludedUrl;
        this.myName = excludedUrl.startsWith(rootUrl) ? ((relativePath = StringUtil.trimStart((String)excludedUrl.substring(rootUrl.length()), (String)"/")).isEmpty() ? "<all>" : relativePath) : ItemElement.getPresentablePath(excludedUrl);
        this.myColor = ExcludedRootElement.getForegroundColor(VirtualFileManager.getInstance().findFileByUrl(excludedUrl) != null);
        this.setIcon(AllIcons.Modules.ExcludeRoot);
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ExcludedRootElement", "getUrl"));
        }
        return string;
    }
}

